<?php
define('APP_ROOT', dirname(__FILE__, 2));                // Katalog główny
require APP_ROOT . '/src/funkcje.php';                   // Funkcje
require APP_ROOT . '/config/config.php';                 // Plik konfiguracyjny

if (DEV === false) {
    set_exception_handler('obsluga_wyjatkow');           // Określ procedurę obsługi wyjątków
    set_error_handler('obsluga_bledow');                 // Określ procedurę obsługi błędów
    register_shutdown_function('obsluga_zamkniecia');    // Określ procedurę zamykającą
}

spl_autoload_register(function($klasa)                   // Funkcja ładująca
{
    $sciezka = APP_ROOT . '/src/klasy/';                 // Ścieżka do definicji klas
    require $sciezka . $klasa . '.php';                  // Dołącz definicje klas
});

$cms = new CMS($dsn, $uzytkownik, $haslo);               // Utwórz obiekt CMS
unset($dsn, $uzytkownik, $haslo);                        // Usuń dane o połączeniu z bazą