<?php
declare(strict_types=1);                                 // Użyj ścisłej kontroli typów
include '../../src/bootstrap.php';                       // Dołącz plik konfiguracyjny
$usunieto = null;                                        // Czy publikacja została usunięta?

$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);// Sprawdź id
if (!$id) {                                              // Jeśli nie ma prawidłowego id
    przekieruj('admin/publikacje.php', ['niepowodzenie' => 'Nie odnalezieono publikacji']); // Przekieruj z błędem
}

$publikacja = $cms->pobierzPublikacje()->pobierz($id, false);  // Pobierz publikację
if (!$publikacja) {                                            // Jeśli nie ma publikacji
    przekieruj('admin/publikacje.php', ['niepowodzenie' => 'Nie odnalezieono publikacji']); // Przekieruj z błędem
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {              // Jeśli formularz został przesłany
    if (isset($publikacja['id_obrazu'])) {               // Jeśli był obraz
        $sciezka = APP_ROOT . '/public/wyslane/' . $publikacja['obraz_plik']; // Ustal ścieżkę do obrazu
        $cms->pobierzPublikacje()->usunObraz($publikacja['id_obrazu'], $sciezka, $id); // Usuń obraz
    }
    $usunieto = $cms->pobierzPublikacje()->usun($id);    // Usuń publikację
    if ($usunieto === true) {                            // Jeśli usunięta
        przekieruj('admin/publikacje.php', ['sukces' => 'Publikacja została usunięta']); // Przekieruj
    } else {                                             // W przeciwnym razie
        throw new Exception('Nie udało się usunąć publikacji'); // Wyrzuć wyjątek
    }
}
?>
<?php include APP_ROOT . '/public/dolaczane/admin-naglowek.php'; ?>
  <main class="container admin" id="content">
    <form action="usun-publikacje.php?id=<?= $id ?>" method="POST" class="narrow">
      <h1>Usuń publikację</h1>
      <p>Kliknij <em>Potwierdź</em>, aby usunąć publikację: <em><?= zastap_html($publikacja['tytul']) ?></em></p>
      <input type="submit" name="delete" value="Potwierdź" class="btn btn-primary">
      <a href="publikacje.php" class="btn btn-danger">Anuluj</a>
    </form>
  </main>
<?php include APP_ROOT . '/public/dolaczane/admin-stopka.php'; ?>