<?php
require '../cms/dolaczane/polaczenie-baza.php';
require '../cms/dolaczane/funkcje.php';

$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$id) {                                  // Jeśli nie ma id
    include 'nie-odnaleziono-strony.php';    // Strony nie odnaleziono
}

$sql       = "SELECT imie, nazwisko
                FROM uczestnicy
               WHERE id = :id;";             // Zapytanie SQL
$instrukcja = $pdo->prepare($sql);           // Przygotuj
$instrukcja->execute([':id' => $id]);        // Wykonaj
$uczestnik  = $instrukcja->fetch();          // Pobierz dane

if (!$uczestnik)    {                        // Jeśli nie ma danych
    include 'nie-odnaleziono-strony.php';    // Strony nie odnaleziono
}
?>
<!DOCTYPE html>
<html>
  <head>
    <meta charset="UTF-8">
    <title>Zapytanie na podstawie danych z adresu URL</title>
    <link rel="stylesheet" type="text/css" href="css/styles.css" />
  </head>
  <body>
    <p>
      <?= zastap_html($uczestnik['imie']) ?>
      <?= zastap_html($uczestnik['nazwisko']) ?>
    </p>
  </body>
</html>