<?php
declare(strict_types = 1);                               // Use strict types
use PhpMysql\Weryfikacja\Weryfikacja;                    // Użyj klasy Weryfikacja

include '../src/bootstrap.php';                          // Plik konfiguracyjny

$publikacja = [];                                        // Dane publikacji
$bledy  = [];                                            // Komunikaty błędów
$tymcz        = $_FILES['obraz']['tmp_name'] ?? '';      // Obraz tymczasowy
$cel = '';                                               // Miejsce zapisania pliku
$zapisano       = null;                                  // Czy publikacja została zapisana

$id          = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT); // Pobierz i sprawdź id
if ($id) {                                               // Jeśli jest id - edytuj istniejącą pracę
    $publikacja = $cms->pobierzPublikacje()->pobierz($id);  // Pobierz dane publikacji
    if (!$publikacja) {                                     // Jeśli artykuł jest pusty
        include APP_ROOT . '/public/nie-odnaleziono-strony.php'; // Nie odnaleziono strony
    }
    if ($publikacja['id_uczestnika'] !== $cms->pobierzSesje()->id) { // Jeśli nie jest to autor publikacji
        include APP_ROOT . '/public/nie-odnaleziono-strony.php'; // Nie odnaleziono strony
    }
}

$zapisano_obraz = $publikacja['obraz_plik'] ?? false;       // Czy zdjęcie zostało wysłane?
$kategorie  = $cms->pobierzKategorie()->pobierzWszystko();  // Pobierz kategorie

if ($_SERVER['REQUEST_METHOD'] == 'POST') {                 // Formularz przesłany
    // Jeśli plik jest większy niż limit podany w plikach php.ini lub .htaccess zapisz komunikat błędu
    $bledy['obraz_plik'] = ($_FILES['obraz']['error'] === 1) ? 'Plik za duży ' : '';

    // Jeśli plik został przesłany, pobierz dane obrazu i sprawdź
    if ($tymcz and $_FILES['obraz']['error'] == 0) {        // Kontrola pliku
        $bledy['obraz_plik']  = in_array(mime_content_type($tymcz), TYPY_MIME)
            ? '' : 'Nieobsługiwany typ pliku. ';            // Typ pliku
        $bledy['obraz_plik'] .= ($_FILES['obraz']['size'] <= MAX_ROZMIAR)
            ? '' : 'Plik jest za duży. ';                   // Rozmiar pliku

        $publikacja['obraz_alt'] = $_POST['obraz_alt'];     // Pobierz tekst zastępczy
        $bledy['obraz_alt']  = Weryfikacja::czyTekst($publikacja['obraz_alt'], 1, 254)
            ? '' : 'Tekst zastępczy może mieć 1-1000 znaków.';    // Tekst zastępczy

        if ($bledy['obraz_plik'] == '' and $bledy['obraz_alt'] == '') { // Jeśli prawidlowe
            $publikacja['obraz_plik'] = utworz_nazwepliku($_FILES['obraz']['name'], 'wyslane/'); // Nazwa pliku
            $cel = WYSLANE . $publikacja['obraz_plik'];
        }
    }

    $publikacja['tytul']         = $_POST['tytul'];           // Pobierz tytuł
    $publikacja['podsumowanie']  = $_POST['podsumowanie'];    // Pobierz podsumowanie
    $publikacja['tresc']         = $_POST['tresc'];           // Pobierz treść
    $publikacja['id_uczestnika'] = $_POST['id_uczestnika'];   // Pobierz id_uczestnika
    $publikacja['id_kategorii']  = $_POST['id_kategorii'];    // Pobierz id_kategorii
    $publikacja['opublikowano']  = 1;                         // Ustaw na opublikowany
    $publikacja['seo_tytul']     = utworz_nazwe_seo($publikacja['tytul']);   // Utworz wersję seo tytułu

    $purifier = new HTMLPurifier();                                                    // Utwórz obiekt HTMLPurifier
    $purifier->config->set('HTML.Allowed', 'p,br,strong,em,b,i,a[href],img[src|alt]'); // Dozwolone znaczniki
    $publikacja['tresc'] = $purifier->purify($publikacja['tresc']);                    // Oczyść treść

    $bledy['tytul']    = (Weryfikacja::czyTekst($publikacja['tytul'], 1, 80))
        ? '' : 'Tytuł powinien mieć 1 - 80 znaków.';                      // Sprawdź tytuł
    $bledy['podsumowanie']  = (Weryfikacja::czyTekst($publikacja['podsumowanie'], 1, 254))
        ? '' : 'Podsumowanie powinno mieć 1 - 254 znaków.';               // Sprawdź podsumowanie
    $bledy['tresc']  = (Weryfikacja::czyTekst($publikacja['tresc'], 1, 100000))
        ? '' : 'Treść powinna mieć 1 - 100 000 znaków.';                  // Sprawdź treść
    $bledy['kategoria'] = Weryfikacja::czyIdKategorii($publikacja['id_kategorii'], $kategorie)
        ? '' : 'Nieprawidłowa kategoria';                                 // Sprawdź kategorię

    $tymcz = $_FILES['obraz']['tmp_name'] ?? '';                          // Tymczasowy obraz


    if ($id == false and $tymcz == '') {                                  // Jeśli artykuł jest nowy i nie tymczasowej ścieżki obrazu
        $bledy['obraz_plik'] = 'Proszę przesłać obraz';                   // Dodaj komunikat o przesłaniu obrazu
    }

    $nieprawidlowe = implode($bledy);                                     // Połącz komunikaty błędów

    if ($nieprawidlowe) {                                                 // W razie nieprawidłowych danych
        $bledy['wiadomosc'] = 'Proszę poprawić błędy w formularzu';       // Zapisz komunikat
    } else {                                                              // W przeciwnym razie
        if ($id) {                                                        // Jeśli id istnieje: zaktualizuj
            $zapisano = $cms->pobierzPublikacje()->aktualizuj($publikacja, $tymcz, $cel); // Zaktualizuj publikację
        } else {                                                          // Brak id: utwórz
            $zapisano = $cms->pobierzPublikacje()->utworz($publikacja, $tymcz, $cel);     // Utwórz publikację
        }
        if ($zapisano === true) {                                         // Jeśli aktualizacja
            przekieruj('uczestnik.php', ['id'=>$cms->pobierzSesje()->id]);// Przekieruj na stronę użytkownika
        } else {
            $bledy['wiadomosc'] = 'Tytuł publikacji został już użyty';    // Zapisz komunikat
        }
    }
    $publikacja['obraz_plik'] = $zapisano_obraz ? $publikacja['obraz_plik'] : '';  // Usuń obraz w przypadku nowej publikacji
}

$dane['nawigacja']  = $kategorie;                                  // Nawigacja
$dane['kategorie']  = $kategorie;                                  // Kategorie do listy
$dane['publikacja'] = $publikacja;                                 // Publikacja
$dane['bledy']      = $bledy;                                      // Błędy

echo $twig->render('praca.html', $dane);                           // Wyrenderuj szablon Twiga