<?php
declare(strict_types = 1);                               // Włącz ścisłą kontrolę typów
use PhpMysql\Weryfikacja\Weryfikacja;                    // Dołącz klasę Weryfikacja

include '../src/bootstrap.php';                          // Plik konfiguracyjny

$id = $cms->pobierzSesje()->id;                          // Pobierz id uczestnika z sesji
if ($id === 0) {                                         // Jeśli nie zalogowany
    przekieruj('logowanie/');                            // Nie odnaleziono strony
}

$bledy  = [];                                            // Komunikaty błędów

if ($_SERVER['REQUEST_METHOD'] != 'POST') {              // Jeśli formularz nie został wysłany
    $uczestnik  = $cms->pobierzUczestnika()->pobierz($cms->pobierzSesje()->id); // Pobierz dane użytkownika
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {              // Jeśli formularz został wysłany
    $uczestnik['id']       = $cms->pobierzSesje()->id;   // Pobierz id użytkownika
    $uczestnik['imie'] = $_POST['imie'];                 // Pobierz imię
    $uczestnik['nazwisko']  = $_POST['nazwisko'];        // Pobierz nazwisko
    $uczestnik['email']    = $_POST['email'];            // Pobierz e-mail
    $uczestnik['rola']     = $cms->pobierzSesje()->rola; // Pobierz rolę

    // Skontroluj dane z formularza
    $bledy['imie'] = Weryfikacja::czyTekst($uczestnik['imie'], 1, 254) ? '' :
        'Imię powinno się składać z 1 - 254 znaków';
    $bledy['nazwisko']  = Weryfikacja::czyTekst($uczestnik['nazwisko'], 1, 254) ? '' :
        'Nazwisko powinno się składać 1 - 254 znaków';
    $bledy['email']    = Weryfikacja::czyEmail($uczestnik['email']) ? '' :
        'Proszę podać prawidłowy adres e-mail';

    $nieprawidlowe = implode($bledy);                               // Połącz komunikaty błędów
    if ($nieprawidlowe) {                                           // Jeśli weryfikacja się nie powiodła
        $bledy['wiadomosc'] = 'Proszę poprawić błędy w formularzu'; // Zapisz komunikat błędu
    } else {                                                        // W przeciwnym razie
        $rezultat = $cms->pobierzUczestnika()->aktualizuj($uczestnik);       // Zaktualizuj dane użytkownika
        if ($rezultat === false) {                                  // Jeśli $rezultat ma wartość fasle
            $bledy['wiadomosc'] = 'Podany adres e-mail jest już używany';    // Zapisz komunikat błędu
        } else {                                                    // W przeciwnym razie
            $cms->pobierzSesje()->odswiez($uczestnik);              // Odśwież sesję
            przekieruj('uczestnik.php', ['id'=>$uczestnik['id'], 'sukces'=>'Profil zapisany',]); // Przekieruj na stronę profilową
        }
    }
}

$dane['nawigacja'] = $cms->pobierzKategorie()->pobierzWszystko();   // Wszystkie kategorie do nawigacji
$dane['uczestnik'] = $uczestnik;                                    // Dane użytkownika
$dane['bledy']     = $bledy;                                        // Komunikaty błędów

echo $twig->render('edytuj-profil-uczestnika.html', $dane);   // Wyrenderuj szablon Twiga