<?php
// CZĘŚĆ A: Przygotowanie
declare(strict_types = 1);                               // Włącz ścisłą kontrolę typów
use PhpMysql\Weryfikacja\Weryfikacja;                    // Zaimportuj przestrzeń nazw Weryfikacja

include '../../src/bootstrap.php';                       // Plik konfiguracyjny

// Inicjalizacja zmiennych potrzebnych w kodzie PHP
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);// Pobierz i sprawdź id
$zapisano = null;                                        // Czy kategoria została zapisana

// Inicjalizacja zmiennych potrzebnych na stronie HTML
$kategoria = [
    'id'          => $id,
    'nazwa'       => '',
    'opis'        => '',
    'nawigacja'   => false,
];                                                       // Inicjalizacja tablicy kategorii
$bledy = [
    'ostrzezenie' => '',
    'nazwa'       => '',
    'opis'        => '',
];                                                       // Inicjalizacja tablicy błędów

if ($id) {                                               // Jeśli nie podano id
    $kategoria = $cms->pobierzKategorie()->pobierz($id); // Pobierz dane kategoriii
    if (!$kategoria) {                                   // Jeśli nie ma danych kategorii
        przekieruj('admin/kategorie.php', ['niepowodzenie' => 'Nie odnaleziono kategorii']); // Przekieruj z błędem
    }
}

// CZĘŚĆ B: Pobierz i zweryfikuj dane z formularza
if ($_SERVER['REQUEST_METHOD'] == 'POST') {                 // Jeśli przesłano formularz
    $kategoria['nazwa']        = $_POST['nazwa'];           // Pobierz nazwę
    $kategoria['opis']         = $_POST['opis'];            // Pobierz opis
    $kategoria['nawigacja']    = (isset($_POST['nawigacja']) and ($_POST['nawigacja'] == 1)) ? 1 : 0; // Pobierz nawigację
    // Sprawdź poprawność wszystkich danych i utwórz komunikaty w razie błędów 
    $bledy['nazwa']          = (Weryfikacja::czyTekst($kategoria['nazwa'], 1, 24))
        ? '' : 'Nazwa powinna składać się z 1-24 znaków.';  // Sprawdź nazwę
    $bledy['opis']   = (Weryfikacja::czyTekst($kategoria['opis'], 1, 254))
        ? '' : 'Opis powinien składać się z 1-254 znaków.'; // Sprawdź opis

    $nieprawidlowe = implode($bledy);                       // Połącz komunikaty błędów

// CZĘŚĆ C: Po skontrolowaniu poprawności danych zaktualizuj bazę
    if ($nieprawidlowe) {                                   // Jeśli dane są nieprawidłowe
        $bledy['ostrzezenie'] = 'Proszę poprawić błędy';    // Komunikat błędu
    } else {                                                // W przeciwnym razie utwórz lub zaktualizuj
        $argumenty = $kategoria;                            // Definicja tablicy $argumenty dla SQL
        if ($id) {                                          // Jeśli jest id
            $zapisano = $cms->pobierzKategorie()->aktualizuj($argumenty); // spróbuj zaktualizować kategorię
        } else {                                            // Jeśli nie ma id
            unset($argumenty['id']);                        // Usuń id z tablicy
            $zapisano = $cms->pobierzKategorie()->utworz($argumenty); // Spróbuj utworzyć kategorię
        }
        if ($zapisano === true) {                           // Jeśli się udało
            przekieruj('admin/kategorie.php', ['sukces' => 'Kategoria zapisana']); // Przekieruj
        }
        if ($zapisano === false) {                          // Jeśli nazwa kategorii  istnieje
            $bledy['ostrzezenie'] = 'Nazwa kategorii już istnieje'; // Zapisz komunikat błędu
        }
    }
}

$dane['kategoria'] = $kategoria;                            // Dodaj kategorię do szablonu
$dane['bledy']   = $bledy;                                  // Dodaj błędy do szablonu

echo $twig->render('admin/kategoria.html', $dane);          // Wyrenderuj szablon