<?php
declare(strict_types=1);                                  // Użyj ścisłej kontroli typów
include '../src/bootstrap.php';                           // Plik konfiguracyjny

$term  = filter_input(INPUT_GET, 'term');                 // Pobierz szukany termin
$pokaz  = filter_input(INPUT_GET, 'pokaz', FILTER_VALIDATE_INT) ?? 3; // Limit
$od  = filter_input(INPUT_GET, 'od', FILTER_VALIDATE_INT) ?? 0; // Przesunięcie
$liczba = 0;                                              // Ustaw licznik na 0
$publikacje = [];                                         // Zainicjalizuj pustą tablicę publikacji

if ($term) {                                              // Jeśli wyszukiwany termin został podany
    $liczba = $cms->pobierzPublikacje()->policzWyniki($term);      // Pobierz liczbę dopasowań
    if ($liczba > 0) {
        $publikacje = $cms->pobierzPublikacje()->szukaj($term, $pokaz, $od); // Pobierz dopasowania
      }
}

if ($liczba > $pokaz) {                                     // Dla więcej niż 3 rezultatów
    $liczba_stron  = ceil($liczba / $pokaz);                // Określ liczbę stron
    $biezaca_strona = ceil($od / $pokaz) + 1;               // Bieżąca strona
}
$nawigacja  = $cms->pobierzKategorie()->pobierzWszystko();  // Pobierz kategorie
$sekcja    = '';                                            // Bieżąca kategoria
$tytul      = 'Wyniki wyszukiwania dla ' . zastap_html($term); // Treść elementu HTML <title>
$opis = $tytul . ' w Creative Folk';                        // Treść opisu meta
?>
<?php include 'dolaczane/naglowek.php'; ?>
  <main class="container" id="content">
    <section class="header">
      <form action="szukaj.php" method="get" class="form-search">
        <label for="search"><span>Wyszukaj: </span></label>
        <input type="text" name="term" value="<?= zastap_html($term) ?>" 
               id="search" placeholder="Wpisz szukane słowo"  
        /><input type="submit" value="Szukaj" class="btn btn-search" />
      </form>
      <?php if ($term) { ?><p><b>Znaleziono</b> <?= $liczba ?> wyników</p><?php } ?>
    </section>

    <section class="grid">
      <?php foreach ($publikacje as $publikacja) { ?>
      <article class="summary">
        <a href="publikacja.php?id=<?= $publikacja['id'] ?>">
          <img src="wyslane/<?= zastap_html($publikacja['obraz_plik'] ?? 'blank.png') ?>"
               alt="<?= zastap_html($publikacja['obraz_alt']) ?>">
          <h2><?= zastap_html($publikacja['tytul']) ?></h2>
          <p><?= zastap_html($publikacja['podsumowanie']) ?></p>
        </a>
        <p class="credit">
          Zamieszczono w <a href="kategoria.php?id=<?= $publikacja['id_kategorii'] ?>">
          <?= zastap_html($publikacja['kategoria']) ?></a>
          przez: <a href="uczestnik.php?id=<?= $publikacja['id_uczestnika'] ?>">
          <?= zastap_html($publikacja['autor']) ?></a>
        </p>
      </article>
      <?php } ?>
    </section>

    <?php if ($liczba > $pokaz) { ?>
    <nav class="pagination" role="navigation" aria-label="Stronicowanie nawigacji">
      <ul>
      <?php for ($i = 1; $i <= $liczba_stron; $i++) { ?>
        <li>
          <a href="?term=<?= $term ?>&pokaz=<?= $pokaz ?>&od=<?= (($i - 1) * $pokaz) ?>"
            class="btn <?= ($i == $biezaca_strona) ? 'active" aria-current="true' : '' ?>">
            <?= $i ?>
          </a>
        </li>
      <?php } ?>
      </ul>
    </nav>
    <?php } ?>

  </main>
<?php include 'dolaczane/stopka.php'; ?>