<?php
declare(strict_types=1);                                 // Użyj ścisłej kontroli typów
include '../../src/bootstrap.php';                       // Dołącz plik konfiguracyjny

$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);// Pobierz i sprawdź id
$publikacja = [];                                        // Inicjalizacja tablicy $publikacja
$bledy  = [
    'alt'     => '',
    'ostrzezenie' => '',
];                                                       // Inicjalizacja komunikatów błędów

if (!$id) {                                              // Jeśli nie ma id
    przekieruj('admin/publikacje.php', ['niepowodzenie' => 'Nie odnaleziono publikacji']); // Przekieruj
}

$publikacja = $cms->pobierzPublikacje()->pobierz($id, false);  // Pobierz publikację
if (!$publikacja['obraz_plik']) {                              // Jeśli nie ma publikacji
    przekieruj('admin/publikacja.php', ['id' => $id]);         // Przekieruj
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {                    // Jeśli formularz został przesłany
    $publikacja['obraz_alt'] = $_POST['obraz_alt'];            // Pobierz tekst zastępczy

    $bledy['alt'] = (Weryfikacja::czyTekst($publikacja['obraz_alt'], 1, 254))
        ? '' : 'Tekst zastępczy musi mieć 1-254 znaków.';      // Sprawdź tekst zastępczy

    if ($bledy['alt']) {                                       // Jeśli nie jest prawidłowy
        $bledy['ostrzezenie'] = 'Prosimy o poprawienie błędu'; // Zapisz komunikat błędu
    } else {
        $cms->pobierzPublikacje()->aktualizujAlt($publikacja['id_obrazu'], $publikacja['obraz_alt']); // Zmiana tekstu zastępczeo
        przekieruj('admin/publikacja.php', ['id' => $id]);     // Powrót do strony publikacji
    }
}
?>
<?php include APP_ROOT . '/public/dolaczane/admin-naglowek.php'; ?>
  <main class="container admin" id="content">
    <form action="edytuj-alt.php?id=<?= $id ?>" method="POST" class="narrow">
      <h1>Zmień tekst zastępczy</h1>
      <?php if ($bledy['ostrzezenie']) { ?><div class="alert alert-danger"><?= $bledy['ostrzezenie'] ?></div><?php } ?>

      <div class="form-group">
        <label for="obraz_alt">Tekst zastępczy: </label>
        <input type="text" name="obraz_alt" id="obraz_alt" value="<?= zastap_html($publikacja['obraz_alt']) ?>"  class="form-control">
        <span class="errors"><?= $bledy['alt'] ?></span>
      </div>

      <div class="form-group">
        <input type="submit" name="delete" value="Aktualizuj" class="btn btn-primary btn-save">
      </div>

      <img src="../wyslane/<?= zastap_html($publikacja['obraz_plik']) ?>" alt="<?= $publikacja['obraz_alt'] ?>">
    </form>
  </main>
<?php include APP_ROOT . '/public/dolaczane/admin-stopka.php'; ?>