<?php
declare(strict_types = 1);                                  // Użyj ścisłej kontroli typów
require '../dolaczane/polaczenie-baza.php';                 // Połączenie z bazą
require '../dolaczane/funkcje.php';                         // Dołącz funkcje

$sukces = $_GET['sukces'] ?? null;                          // Sprawdź komunikat o powodzeniu
$niepowodzenie = $_GET['niepowodzenie'] ?? null;            // Sprawdź komunikat o niepowodzeniu

$sql = "SELECT p.id, p.tytul, p.podsumowanie, p.utworzono, p.id_kategorii, p.id_uczestnika, p.opublikowano,
               k.nazwa      AS kategoria,
               CONCAT(u.imie, ' ', u.nazwisko) AS autor,
               o.plik       AS obraz_plik,
               o.alt        AS obraz_alt 
          FROM publikacje   AS p
          JOIN kategorie    AS k   ON p.id_kategorii  = k.id
          JOIN uczestnicy   AS u   ON p.id_uczestnika = u.id
          LEFT JOIN obrazy  AS o   ON p.id_obrazu     = o.id
         ORDER BY p.id DESC;";                              // Zapytanie SQL o streszczenia publikacji
$publikacje = pdo($pdo, $sql)->fetchAll();                  // Pobierz streszczenia publikacji
?>
<?php include '../dolaczane/admin-naglowek.php'; ?>
  <main class="container" id="content">
    <section class="header">
      <h1>Publikacje</h1>
      <?php if ($sukces) { ?><div class="alert alert-success"><?= $sukces ?></div><?php } ?>
      <?php if ($niepowodzenie) { ?><div class="alert alert-danger"><?= $niepowodzenie ?></div><?php } ?>
      <p><a href="publikacja.php" class="btn btn-primary">Dodaj nową publikację</a></p>
    </section>
    <table>
      <tr>
        <th>Obraz</th><th>Tytuł</th><th class="created">Utworzono</th><th class="pub">Widoczna</th><th class="edit">Zmień</th><th class="del">Usuń</th>
      </tr>
      <?php foreach ($publikacje as $publikacja) { ?>
      <tr>
        <td><img src="../wyslane/<?= zastap_html($publikacja['obraz_plik'] ?? 'blank.png') ?>"
                 alt="<?= zastap_html($publikacja['obraz_alt']) ?>"></td>
        <td><strong><?= zastap_html($publikacja['tytul']) ?></strong></td>
        <td><?= formatuj_date($publikacja['utworzono']) ?></td>
        <td><?= ($publikacja['opublikowano']) ? 'Tak' : 'Nie' ?></td>
        <td><a href="publikacja.php?id=<?= $publikacja['id'] ?>" class="btn btn-primary">Zmień</a></td>
        <td><a href="usun-publikacje.php?id=<?= $publikacja['id'] ?>" class="btn btn-danger">Usuń</a></td>
      </tr>
      <?php } ?>
    </table>
  </main>
<?php include '../dolaczane/admin-stopka.php'; ?>