<?php
set_exception_handler('obsluga_wyjatkow');                         // Skonfiguruj obsługę wyjątków
function obsluga_wyjatkow($e)
{
    error_log($e);                                                 // Zarejestruj błąd
    http_response_code(500);                                       // Ustaw kod odpowiedzi
    require_once 'naglowek.php';                                   // Dołącz nagłówek
    echo "<h1>Przepraszamy za usterki.</h1>
          <p>Administratorzy strony zostali poinformowani o problemie. Prosimy spróbować później.</p>";
    require_once 'stopka.php';                                     // Dołącz stopkę
}

set_error_handler('obsluga_bledow');                                // Skonfiguruj obsługę błędów
function obsluga_bledow($typ, $komunikat, $plik = '', $wiersz = 0)
{
    throw new ErrorException($komunikat, 0, $typ, $plik, $wiersz);  // Wyrzuć obiekt ErrorException
}

register_shutdown_function('obsluga_zamkniecia');                   // Skonfiguruj obsługę zamknięcia
function obsluga_zamkniecia()
{
    $blad = error_get_last();                                       // Czy w skrypcie był błąd?
    if ($blad) {                                                    // Jeśli tak, wyrzuć wyjątek
        $e = new ErrorException($blad['message'], 0, $blad['type'],
                                $blad['file'], $blad['line']);
        obsluga_wyjatkow($e);                                       // Wywołaj funkcję obsługi wyjątków
    }
}