<?php
declare(strict_types = 1);
class Konto
{
    public int    $numer;
    public string $typ;
    public float  $stan;

    public function __construct(int $numer, string $typ, float $stan = 0.00) 
    { 
        $this->numer = $numer;
        $this->typ   = $typ;
        $this->stan  = $stan; 
    }

    public function wplac(float $kwota): float 
    {
        $this->stan += $kwota;
        return $this->stan;
    }

    public function wyplac(float $kwota): float
    {
         $this->stan -= $kwota;
         return $this->stan;
    }
}


$rozliczeniowe   = new Konto(43161176, 'Rozliczeniowe', 32.00);
$oszczednosciowe = new Konto(20148896, 'Oszczędnościowe', 756.00);
?>

<?php include 'dolaczane/naglowek.php'; ?>
<h2>Stan konta</h2>
<table>
  <tr>
    <th>Data</th>
    <th><?= $rozliczeniowe->typ ?></th>
    <th><?= $oszczednosciowe->typ  ?></th>
  </tr>
  <tr>
    <td>23 czerwca</td>
    <td><?= $rozliczeniowe->stan ?> zł</td>
    <td><?= $oszczednosciowe->stan ?> zł</td>
  </tr>
  <tr>
    <td>24 czerwca</td>
    <td><?= $rozliczeniowe->wplac(12.00) ?> zł</td>
    <td><?= $oszczednosciowe->wyplac(100.00) ?> zł</td>
  </tr>
  <tr>
    <td>25 czerwca</td>
    <td><?= $rozliczeniowe->wyplac(5.00) ?> zł</td>
    <td><?= $oszczednosciowe->wplac(300.00) ?> zł</td>
  </tr>
</table>
<?php include 'dolaczane/stopka.php'; ?>
