<?php
declare(strict_types = 1);                                  // Włącz ścisłą kontrolę typów

if (!$id) {                                                 // Jeśli nie ma prawidłowego id
    include APP_ROOT . '/src/strony/nie-odnaleziono-strony.php';     // Nie odnaleziono strony
}

$uczestnik = $cms->pobierzUczestnika()->pobierz($id);       // Pobierz dane użytkownika
if (!$uczestnik) {                                          // Jeśli tablica jest pusta
    include APP_ROOT . '/src/strony/nie-odnaleziono-strony.php';     // Nie odnaleziono strony
}

$dane['nawigacja']  = $cms->pobierzKategorie()->pobierzWszystko();   // Pobierz kategorie
$dane['uczestnik']      = $uczestnik;                                // Dane uczestnika
$dane['sukces']     = $_GET['sukces'] ?? '';                         // Wyświetl wiadomość o sukcesie, jeśli istnieje
$dane['publikacje']    = $cms->pobierzPublikacje()->pobierzWszystko(true, null, $id); // Pobierz publikacje użytkownika

echo $twig->render('uczestnik.html', $dane);                         // Wyrenderuj szablon Twiga