<?php
declare(strict_types = 1);                               // Włącz ścisłą kontrolę typów
include '../src/bootstrap.php';                          // Plik konfiguracyjny

$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);// Sprawdź id
if (!$id) {                                              // Jeśli nie ma prawidłowego id
    include APP_ROOT . '/public/nie-odnaleziono-strony.php';     // Nie odnaleziono strony
}
$publikacja = $cms->pobierzPublikacje()->pobierz($id, false);    // Pobierz dane publikacji
if (!$publikacja) {                                              // Jeśli tablica $publikacja jest pusta
    include APP_ROOT . '/public/nie-odnaleziono-strony.php';     // Nie odnaleziono strony
}
if ($publikacja['id_uczestnika'] !== $cms->pobierzSesje()->id) {  // Jeśli niewłaściwy użytkownik
    include APP_ROOT . '/public/nie-odnaleziono-strony.php';      // Nie odnaleziono strony
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {              // Jeśli formularz został przesłany
    if (isset($publikacja['id_obrazu'])) {               // Jeśli dołączono obraz
        $sciezka = APP_ROOT . '/public/wyslane/' . $publikacja['obraz_plik'];  // Określ ścieżkę do obrazu
        $cms->pobierzPublikacje()->usunObraz($publikacja['id_obrazu'], $sciezka, $publikacja['id']); // Usuń obraz
    }
    $cms->pobierzPublikacje()->usun($id);                // Usuń publikację
    przekieruj('uczestnik.php', ['id'=>$cms->pobierzSesje()->id, 'sukces'=>'Publikacja została usunięta',]); // Przekieruj na stronę profilu
}

$dane['nawigacja']  = $cms->pobierzKategorie()->pobierzWszystko();     // Wszystkie kategorie do nawigacji
$dane['publikacja'] = $publikacja;                       // Dane do szablonu Twiga

echo $twig->render('usun-prace.html', $dane);            // Wyrenderuj szablon Twiga