<?php
declare(strict_types = 1);                               // Włącz ścisłą kontrolę typów

include '../src/bootstrap.php';                          // Plik konfiguracyjny

$bledy  = '';                                            // Komunikaty błędów

$id = $cms->pobierzSesje()->id;                          // Pobierz id użytkownika z sesji
if ($id === 0) {                                         // Jeśli nie zalogowany
    przekieruj('logowanie.php');                         // Nie odnaleziono strony
}
$uczestnik = $cms->pobierzUczestnika()->pobierz($id);    // Pobierz dane użytkownika

$usun = $_POST['skasuj'] ?? '';                          // Sprawdź, czy chodzi o usunięcie zdjęcia
if ($usun === 'skasuj') {                                // Jeśli tak
    $cms->pobierzUczestnika()->usunZdjecie($uczestnik, WYSLANE); // Zaktualizuj
    przekieruj('uczestnik.php', ['id'=>$id, 'sukces'=>'Zdjęcie usunięte',]); // Przeładuj stronę
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {              // Formularz przesłany
    $tymcz = $_FILES['zdjecie']['tmp_name'] ?? '';       // Plik tymczasowy
    if (is_uploaded_file($tymcz) and $_FILES['zdjecie']['error'] == 0) {  // Jeśli plik jest OK
        $bledy  = in_array(mime_content_type($tymcz), TYPY_MIME) 
            ? '' : 'Nieobsługiwany typ pliku. ';                  // Sprawdź typ
        $rozszerzenie = strtolower(pathinfo($_FILES['zdjecie']['name'], PATHINFO_EXTENSION)); // Rozszerzenie małymi literami
        $bledy .= in_array($rozszerzenie, ROZSZERZENIA)
            ? '' : 'Nieobsługiwane rozszerzenie pliku. ';         // Rozszerzenie pliku
        $bledy .= ($_FILES['zdjecie']['size'] <= MAX_ROZMIAR)
            ? '' : 'Plik jest za duży. ';                         // Kontrola rozmiaru

        if (!$bledy) {                                                             // W razie braku błędów
            $nazwapliku = utworz_nazwepliku($_FILES['zdjecie']['name'], WYSLANE);  // Utwórz nazwę pliku
            $cms->pobierzUczestnika()->utworzZdjecie($id, $nazwapliku, $tymcz, WYSLANE . $nazwapliku);   // Zapisz i zaktualizuj
            przekieruj('uczestnik.php', ['id'=>$id, 'sukces'=>'Zdjęcie zmienione',]);  // Przeładuj stronę
        } else {                                                                   // W przeciwnym razie
            $bledy .= 'Spróbuj jeszcze raz.';                                      // Zapisz komunikat 
        }

    } else {                                                                       // W przeciwnym razie
        $bledy = 'Proszę przesłać zdjęcie.';                                       // Zapisz komunikat
    }
}

$dane['nawigacja'] = $cms->pobierzKategorie()->pobierzWszystko();     // Wszystkie kategorie do nawigacji
$dane['uczestnik'] = $uczestnik;                                      // Uczestnik
$dane['bledy']     = $bledy;                                          // Błędy

echo $twig->render('edytuj-zdjecie-uczestnika.html', $dane);   // Wyrenderuj szablon Twiga