<?php
declare(strict_types = 1);                                  // Włącz ścisłą kontrolę typów
include '../../src/bootstrap.php';                          // Dołącz plik konfiguracyjny
czyAdmin($sesja->rola);                                                                   // Sprawdź status administratora

$id      = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT); // Pobierz i sprawdź id
$publikacja = [];                                              // Inicjalizacja tablicy

if (!$id) {                                                 // Jeśli nie ma id
    przekieruj('/admin/publikacje.php', ['niepowodzenie' => 'Nie znaleziono publikacji']); // Przekieruj
}

$publikacja = $cms->pobierzPublikacje()->pobierz($id, false);  // Pobierz publikację
if (!$publikacja) {                                            // Jeśli nie ma publikacji
    przekieruj('admin/publikacje.php', ['niepowodzenie' => 'Nie znaleziono publikacji']); // Przekieruj
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {                  // Jeśli formularz został wysłany
    $sciezka = APP_ROOT . '/public/wyslane/' . $publikacja['obraz_plik']; // Ścieżka do pliku
    $cms->pobierzPublikacje()->usunObraz($publikacja['id_obrazu'], $sciezka, $id); // Usuń obraz
    przekieruj('admin/publikacja.php', ['id' => $id]);           // Przekieruj
}

$dane['publikacja'] = $publikacja;                           // Dane publikacji do szablonu
echo $twig->render('admin/usun-obraz.html', $dane);          // Wyrenderuj szablon