<?php
declare(strict_types=1);                                 // Włącz ścisłą kontrolę typów
use PhpMysql\Weryfikacja\Weryfikacja;                    // Zaimportuj przestrzeń Weryfikacja

include '../../src/bootstrap.php';                       // Dołącz plik konfiguracyjny
czyAdmin($sesja->rola);                                  // Sprawdź status administratora

$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);// Pobierz i sprawdź id
$publikacja = [];                                        // Zainicjalizuj tablicę $publikacja
$bledy = [
    'alt'     => '',
    'ostrzezenie' => '',
];                                                       // Zainicjalizuj tablicę błędów

if (!$id) {                                              // Jeśli nie ma id
    przekieruj('admin/publikacje.php', ['niepowodzenie' => 'Nie odnaleziono publikacji']); // Przekieruj
}

$publikacja = $cms->pobierzPublikacje()->pobierz($id, false);  // Pobierz publikację
if (!$publikacja['obraz_plik']) {                              // Jeśli nie ma publikacji
    przekieruj('admin/publikacja.php', ['id' => $id]);         // Przekieruj
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {                    // Jeśli formularz został przesłany
    $publikacja['obraz_alt'] = $_POST['obraz_alt'];            // Pobierz tekst zastępczy

    $bledy['alt'] = (Weryfikacja::czyTekst($publikacja['obraz_alt'], 1, 254))
        ? '' : 'Tekst zastępczy musi mieć 1-254 znaków.';      // Sprawdź tekst zastępczy

    if ($bledy['alt']) {                                       // Jeśli nie jest prawidłowy
        $bledy['ostrzezenie'] = 'Prosimy o poprawienie błędu'; // Zapisz komunikat błędu
    } else {
        $cms->pobierzPublikacje()->aktualizujAlt($publikacja['id_obrazu'], $publikacja['obraz_alt']); // Zmiana tekstu zastępczego
        przekieruj('admin/publikacja.php', ['id' => $id]);     // Powrót do strony publikacji
    }
}
$dane['publikacja'] = $publikacja;
$dane['bledy']  = $bledy;

echo $twig->render('admin/edytuj-alt.html', $dane);   // Wyrenderuj szablon