<?php
declare(strict_types=1);                                  // Użyj ścisłej kontroli typów
include '../../src/bootstrap.php';                        // Dołącz plik konfiguracyjny

$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT); // Pobierz i sprawdź id
$kategoria = [];                                          // Zainicjalizuj tablicę kategorii
$usunieto  = null;                                        // Czy kategoria została usunięta?

if (!$id) {                                               // Jeśli nie ma prawidłowego id
    przekieruj('admin/kategorie.php', ['niepowodzenie' => 'Nie odnaleziono kategorii']); // Przekieruj z błędem
}

$kategoria = $cms->pobierzKategorie()->pobierz($id);      // Pobierz kategorię
if (!$kategoria) {                                        // Jeśli nie ma prawidłowego id
    przekieruj('admin/kategorie.php', ['niepowodzenie' => 'Nie odnaleziono kategorii']); // Przekieruj z błędem
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {               // Jeśli formularz został przesłany
    if ($id) {                                            // Jeśli id jest prawidłowy
        $usunieto  = $cms->pobierzKategorie()->usun($id); // Usuń kategorię
        if ($usunieto  === true) {                        // Jeśli zadziałało
            przekieruj('admin/kategorie.php', ['sukces' => 'Kategoria została usunięta']); // Przekieruj
        }
        if ($usunieto  === false) {                       // Jeśli kateegoria zawiera publikacje
            przekieruj('admin/kategorie.php', ['niepowodzenie' => 'Kategoria zawiera publikacje, które 
			powinny zostać przeniesione lub skasowane przed jej usunięciem']); // Przekieruj z błędem
        }
    }
}
?>
<?php include APP_ROOT . '/public/dolaczane/admin-naglowek.php'; ?>
  <main class="container admin" id="content">
    <form action="usun-kategorie.php?id=<?= $id ?>" method="POST" class="narrow">
      <h1>Usuń kategorię</h1>
      <p>Kliknij <em>Potwierdź</em>, aby usunąć kategorię: <em><?= zastap_html($kategoria['nazwa']) ?></em></p>
      <input type="submit" name="delete" value="Potwierdź" class="btn btn-primary">
      <a href="kategorie.php" class="btn btn-danger">Anuluj</a>
    </form>
  </main>
<?php include APP_ROOT . '/public/dolaczane/admin-stopka.php'; ?>