﻿<?php
include_once $_SERVER['DOCUMENT_ROOT'] .
        '/includes/magicquotes.inc.php';

require_once $_SERVER['DOCUMENT_ROOT'] . '/includes/access.inc.php';

if (!userIsLoggedIn())
{
    include '../login.html.php';
    exit();
}

if (!userHasRole('Redaktor treści'))
{
    $error = 'Strona dostępna wyłącznie dla Redaktorów treści.';
    include '../accessdenied.html.php';
    exit();
}

if (isset($_GET['add']))
{
    $pagetitle = 'Nowy kawał';
    $action = 'addform';
    $text = '';
    $authorid = '';
    $id = '';
    $button = 'Dodaj kawał';

    include $_SERVER['DOCUMENT_ROOT'] . '/includes/db.inc.php';

    // Stworzenie listy autorów
    $sql = "SELECT id, nazwisko FROM autor";
    $result = mysqli_query($link, $sql);
    if (!$result)
    {
        $error = 'Błąd w trakcie odczytywania listy autorów.';
        include 'error.html.php';
        exit();
    }

    while ($row = mysqli_fetch_array($result))
    {
        $authors[] = array('id' => $row['id'], 'name' => $row['nazwisko']);
    }

    // Stworzenie listy kategorii
    $sql = "SELECT id, nazwa FROM kategoria";
    $result = mysqli_query($link, $sql);
    if (!$result)
    {
        $error = 'Błąd w trakcie odczytywania listy kategorii.';
        include 'error.html.php';
        exit();
    }

    while ($row = mysqli_fetch_array($result))
    {
        $categories[] = array(
                'id' => $row['id'],
                'name' => $row['nazwa'],
                'selected' => FALSE);
    }

    include 'form.html.php';
    exit();
}

if (isset($_GET['addform']))
{
    include $_SERVER['DOCUMENT_ROOT'] . '/includes/db.inc.php';

    $text = mysqli_real_escape_string($link, $_POST['text']);
    $author = mysqli_real_escape_string($link, $_POST['author']);

    if ($author == '')
    {
        $error = 'Należy wskazać autora kawału.
                Kliknij ‘powrót’ i spróbuj ponownie.';
        include 'error.html.php';
        exit();
    }

    $sql = "INSERT INTO kawal SET
            tekstkawalu='$text',
            datakawalu=CURDATE(),
            idautora='$author'";
    if (!mysqli_query($link, $sql))
    {
        $error = 'Błąd w trakcie dodawania kawału.';
        include 'error.html.php';
        exit();
    }

    $jokeid = mysqli_insert_id($link);

    if (isset($_POST['categories']))
    {
        foreach ($_POST['categories'] as $category)
        {
            $categoryid = mysqli_real_escape_string($link, $category);
            $sql = "INSERT INTO kategoriakawalu SET
                    idkawalu='$jokeid',
                    idkategorii='$categoryid'";
            if (!mysqli_query($link, $sql))
            {
                $error = 'Błąd w trakcie przypisywania kategorii do kawału.';
                include 'error.html.php';
                exit();
            }
        }
    }

    header('Location: .');
    exit();
}

if (isset($_POST['action']) and $_POST['action'] == 'Edytuj')
{
    include $_SERVER['DOCUMENT_ROOT'] . '/includes/db.inc.php';

    $id = mysqli_real_escape_string($link, $_POST['id']);
    $sql = "SELECT id, tekstkawalu, idautora FROM kawal WHERE id='$id'";
    $result = mysqli_query($link, $sql);
    if (!$result)
    {
        $error = 'Błąd w trakcie odczytywania kawału.';
        include 'error.html.php';
        exit();
    }
    $row = mysqli_fetch_array($result);

    $pagetitle = 'Edycja kawału';
    $action = 'editform';
    $text = $row['tekstkawalu'];
    $authorid = $row['idautora'];
    $id = $row['id'];
    $button = 'Uaktualnij kawał';

    // Stworzenie listy autorów
    $sql = "SELECT id, nazwisko FROM autor";
    $result = mysqli_query($link, $sql);
    if (!$result)
    {
        $error = 'Błąd w trakcie odczytywania listy autorów.';
        include 'error.html.php';
        exit();
    }

    while ($row = mysqli_fetch_array($result))
    {
        $authors[] = array('id' => $row['id'], 'name' => $row['nazwisko']);
    }

    // Odczytanie listy kategorii, do których należy kawał
    $sql = "SELECT idkategorii FROM kategoriakawalu WHERE idkawalu='$id'";
    $result = mysqli_query($link, $sql);
    if (!$result)
    {
        $error = 'Błąd w trakcie odczytywania listy zaznaczonych kategorii.';
        include 'error.html.php';
        exit();
    }

    $selectedCategories = array();
    while ($row = mysqli_fetch_array($result))
    {
        $selectedCategories[] = $row['idkategorii'];
    }

    // Stworzenie listy wszystkich kategorii
    $sql = "SELECT id, nazwa FROM kategoria";
    $result = mysqli_query($link, $sql);
    if (!$result)
    {
        $error = 'Błąd w trakcie odczytywania listy kategorii.';
        include 'error.html.php';
        exit();
    }

    while ($row = mysqli_fetch_array($result))
    {
        $categories[] = array(
                'id' => $row['id'],
                'name' => $row['nazwa'],
                'selected' => in_array($row['id'], $selectedCategories));
    }

    include 'form.html.php';
    exit();
}

if (isset($_GET['editform']))
{
    include $_SERVER['DOCUMENT_ROOT'] . '/includes/db.inc.php';

    $text = mysqli_real_escape_string($link, $_POST['text']);
    $author = mysqli_real_escape_string($link, $_POST['author']);
    $id = mysqli_real_escape_string($link, $_POST['id']);

    if ($author == '')
    {
        $error = 'Należy wskazać autora kawału.
                Kliknij ‘powrót’ i spróbuj ponownie.';
        include 'error.html.php';
        exit();
    }

    $sql = "UPDATE kawal SET
            tekstkawalu='$text',
            idautora='$author'
            WHERE id='$id'";
    if (!mysqli_query($link, $sql))
    {
        $error = 'Błąd w trakcie zmiany kawału.';
        include 'error.html.php';
        exit();
    }

    $sql = "DELETE FROM kategoriakawalu WHERE idkawalu='$id'";
    if (!mysqli_query($link, $sql))
    {
        $error = 'Błąd w trakcie usuwania przypisań kategorii do kawału.';
        include 'error.html.php';
        exit();
    }

    if (isset($_POST['categories']))
    {
        foreach ($_POST['categories'] as $category)
        {
            $categoryid = mysqli_real_escape_string($link, $category);
            $sql = "INSERT INTO kategoriakawalu SET
                    idkawalu='$id',
                    idkategorii='$categoryid'";
            if (!mysqli_query($link, $sql))
            {
                $error = 'Błąd w trakcie wstawiania kawału do wybranej kategorii.';
                include 'error.html.php';
                exit();
            }
        }
    }

    header('Location: .');
    exit();
}

if (isset($_POST['action']) and $_POST['action'] == 'Usuń')
{
    include $_SERVER['DOCUMENT_ROOT'] . '/includes/db.inc.php';
    $id = mysqli_real_escape_string($link, $_POST['id']);

    // Usunięcie przypisań kategorii do kawału
    $sql = "DELETE FROM kategoriakawalu WHERE idkawalu='$id'";
    if (!mysqli_query($link, $sql))
    {
        $error = 'Błąd w trakcie usuwania kawału z kategorii.';
        include 'error.html.php';
        exit();
    }

    // Usunięcie kawału
    $sql = "DELETE FROM kawal WHERE id='$id'";
    if (!mysqli_query($link, $sql))
    {
        $error = 'Błąd w trakcie usuwania kawału.';
        include 'error.html.php';
        exit();
    }

    header('Location: .');
    exit();
}

if (isset($_GET['action']) and $_GET['action'] == 'search')
{
    include $_SERVER['DOCUMENT_ROOT'] . '/includes/db.inc.php';

    // Podstawowe zapytanie SELECT
    $select = 'SELECT id, tekstkawalu';
    $from   = ' FROM kawal';
    $where  = ' WHERE TRUE';

    $authorid =  mysqli_real_escape_string($link, $_GET['author']);
    if ($authorid != '') // Wybrano autora
    {
        $where .= " AND idautora='$authorid'";
    }

    $categoryid =  mysqli_real_escape_string($link,
            $_GET['category']);
    if ($categoryid != '') // Wybrano kategorię
    {
        $from  .= ' INNER JOIN kategoriakawalu ON id = idkawalu';
        $where .= " AND idkategorii='$categoryid'";
    }

    $text = mysqli_real_escape_string($link, $_GET['text']);
    if ($text != '') // Wpisano poszukiwany tekst
    {
        $where .= " AND tekstkawalu LIKE '%$text%'";
    }

    $result = mysqli_query($link, $select . $from . $where);
    if (!$result)
    {
        $error = 'Błąd w trakcie odczytywania kawałów.';
        include 'error.html.php';
        exit();
    }

    while ($row = mysqli_fetch_array($result))
    {
        $jokes[] = array('id' => $row['id'], 'text' => $row['tekstkawalu']);
    }

    include 'jokes.html.php';
    exit();
}

// Wyświetlenie formularza wyszukiwania
include $_SERVER['DOCUMENT_ROOT'] . '/includes/db.inc.php';
$result = mysqli_query($link, 'SELECT id, nazwisko FROM autor');
if (!$result)
{
    $error = 'Błąd w trakcie odczytywania autorów z bazy danych!';
    include 'error.html.php';
    exit();
}

while ($row = mysqli_fetch_array($result))
{
    $authors[] = array('id' => $row['id'], 'name' => $row['nazwisko']);
}

$result = mysqli_query($link, 'SELECT id, nazwa FROM kategoria');
if (!$result)
{
    $error = 'Błąd w trakcie odczytywania kategorii z bazy danych!';
    include 'error.html.php';
    exit();
}

while ($row = mysqli_fetch_array($result))
{
    $categories[] = array('id' => $row['id'], 'name' => $row['nazwa']);
}

include 'searchform.html.php';
?>
