CREATE TABLE kawal (
 id INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
 tekstkawalu TEXT,
 datakawalu DATE NOT NULL,
 idautora INT
) DEFAULT CHARACTER SET utf8;

CREATE TABLE autor (
 id INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
 nazwisko VARCHAR(255),
 email VARCHAR(255),
 haslo CHAR(32),
 UNIQUE (email)
) DEFAULT CHARACTER SET utf8;

CREATE TABLE kategoria (
 id INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
 nazwa VARCHAR(255)
) DEFAULT CHARACTER SET utf8;

CREATE TABLE kategoriakawalu (
 idkawalu INT NOT NULL,
 idkategorii INT NOT NULL,
 PRIMARY KEY (idkawalu, idkategorii)
) DEFAULT CHARACTER SET utf8;

CREATE TABLE rola (
 id VARCHAR(255) NOT NULL PRIMARY KEY,
 opis VARCHAR(255)
) DEFAULT CHARACTER SET utf8;

CREATE TABLE rolaautora (
 idautora INT NOT NULL,
 idroli VARCHAR(255) NOT NULL,
 PRIMARY KEY (idautora, idroli)
) DEFAULT CHARACTER SET utf8;

# Przykadowe dane
# Definiujemy identyfikatory, aby utrzyma relacje midzy poszczeglnymi elementami

INSERT INTO autor (id, nazwisko, email) VALUES
(1, 'Kevin Yank', 'kevin@sitepoint.com'),
(2, 'J. Kowalska', 'joasia@przyklad.com');

INSERT INTO kawal (id, tekstkawalu, datakawalu, idautora) VALUES
(1, 'Czemu kurczak przebieg przez drog? eby dosta si na drug stron!', '2009-04-01', 1),
(2, 'Puk, puk! Kto tam? Boo! Jaki Boo? Nie pacz, to tylko taki kawa!', '2009-04-01', 1),
(3, 'Wpada facet na piwo i mwi: "Au!"', '2009-04-01', 2),
(4, 'Ilu prawnikw potrzeba, aby zmieni arowk? Boj si powiedzie, bo mnie pozw.', '2009-04-01', 2);

INSERT INTO kategoria (id, nazwa) VALUES
(1, 'Puk, puk'),
(2, 'Czemu kurczak przebieg'),
(3, 'O prawnikach'),
(4, 'Wpada facet na piwo');

INSERT INTO kategoriakawalu (idkawalu, idkategorii) VALUES
(1, 2),
(2, 1),
(3, 4),
(4, 3);

INSERT INTO rola (id, opis) VALUES
('Redaktor treci', 'Dodaje, usuwa i edytuje kaway'),
('Administrator autorw', 'Dodaje, usuwa i edytuje autorw'),
('Administrator witryny', 'Dodaje, usuwa i edytuje kategorie');

INSERT INTO rolaautora (idautora, idroli) VALUES
(1, 'Administrator klientw');