<?php
include_once $_SERVER['DOCUMENT_ROOT'] .
        '/includes/magicquotes.inc.php';

if (isset($_GET['add']))
{
    $pagetitle = 'Nowy kawał';
    $action = 'addform';
    $text = '';
    $authorid = '';
    $id = '';
    $button = 'Dodaj kawał';

    include $_SERVER['DOCUMENT_ROOT'] . '/includes/db.inc.php';

    // Zbudowanie listy autorów
    $sql = "SELECT id, nazwisko FROM autor";
    $result = mysqli_query($link, $sql);
    if (!$result)
    {
        $error = 'Błąd w trakcie pobierania autorów.';
        include 'error.html.php';
        exit();
    }

    while ($row = mysqli_fetch_array($result))
    {
        $authors[] = array('id' => $row['id'], 'name' => $row['nazwisko']);
    }

    // Zbudowanie listy kategorii
    $sql = "SELECT id, nazwa FROM kategoria";
    $result = mysqli_query($link, $sql);
    if (!$result)
    {
        $error = 'Błąd w trakcie pobierania listy kategorii.';
        include 'error.html.php';
        exit();
    }

    while ($row = mysqli_fetch_array($result))
    {
        $categories[] = array(
                'id' => $row['id'],
                'name' => $row['nazwa'],
                'selected' => FALSE);
    }

    include 'form.html.php';
    exit();
}

if (isset($_GET['addform']))
{
    include $_SERVER['DOCUMENT_ROOT'] . '/includes/db.inc.php';

    $text = mysqli_real_escape_string($link, $_POST['text']);
    $author = mysqli_real_escape_string($link, $_POST['author']);

    if ($author == '')
    {
        $error = 'Należy wybrać autora kawału.
                Kliknij powrót i spróbuj ponownie.';
        include 'error.html.php';
        exit();
    }

    $sql = "INSERT INTO kawal SET
            tekstkawalu='$text',
            datakawalu=CURDATE(),
            idautora='$author'";
    if (!mysqli_query($link, $sql))
    {
        $error = 'Błąd w trakcie dodawania kawału.';
        include 'error.html.php';
        exit();
    }

    $jokeid = mysqli_insert_id($link);

    if (isset($_POST['categories']))
    {
        foreach ($_POST['categories'] as $category)
        {
            $categoryid = mysqli_real_escape_string($link, $category);
            $sql = "INSERT INTO kategoriakawalu SET
                    idkawalu='$jokeid',
                    idkategorii='$categoryid'";
            if (!mysqli_query($link, $sql))
            {
                $error = 'Błąd w trakcie wstawiania kawału do wybranej kategorii.';
                include 'error.html.php';
                exit();
            }
        }
    }

    header('Location: .');
    exit();
}

if (isset($_POST['action']) and $_POST['action'] == 'Edytuj')
{
    include $_SERVER['DOCUMENT_ROOT'] . '/includes/db.inc.php';

    $id = mysqli_real_escape_string($link, $_POST['id']);
    $sql = "SELECT id, tekstkawalu, idautora FROM kawal WHERE id='$id'";
    $result = mysqli_query($link, $sql);
    if (!$result)
    {
        $error = 'Błąd w trakcie odczytywania kawału.';
        include 'error.html.php';
        exit();
    }
    $row = mysqli_fetch_array($result);

    $pagetitle = 'Edycja kawału';
    $action = 'editform';
    $text = $row['tekstkawalu'];
    $authorid = $row['idautora'];
    $id = $row['id'];
    $button = 'Uaktualnij kawał';

    // Zbudowanie listy autorów
    $sql = "SELECT id, nazwisko FROM autor";
    $result = mysqli_query($link, $sql);
    if (!$result)
    {
        $error = 'Błąd w trakcie odczytywania listy autorów.';
        include 'error.html.php';
        exit();
    }

    while ($row = mysqli_fetch_array($result))
    {
        $authors[] = array('id' => $row['id'], 'name' => $row['nazwisko']);
    }

    // Pobranie listy kategorii, do której należy ten kawał
    $sql = "SELECT idkategorii FROM kategoriakawalu WHERE idkawalu='$id'";
    $result = mysqli_query($link, $sql);
    if (!$result)
    {
        $error = 'Błąd w trakcie odczytywania listy wybranych kategorii.';
        include 'error.html.php';
        exit();
    }

    while ($row = mysqli_fetch_array($result))
    {
        $selectedCategories[] = $row['idkategorii'];
    }

    // Zbudowanie listy wszystkich kategorii
    $sql = "SELECT id, nazwa FROM kategoria";
    $result = mysqli_query($link, $sql);
    if (!$result)
    {
        $error = 'Błąd w trakcie odczytywania listy kategorii.';
        include 'error.html.php';
        exit();
    }

    while ($row = mysqli_fetch_array($result))
    {
        $categories[] = array(
                'id' => $row['id'],
                'name' => $row['nazwa'],
                'selected' => in_array($row['id'], $selectedCategories));
    }

    include 'form.html.php';
    exit();
}

if (isset($_GET['editform']))
{
    include $_SERVER['DOCUMENT_ROOT'] . '/includes/db.inc.php';

    $text = mysqli_real_escape_string($link, $_POST['text']);
    $author = mysqli_real_escape_string($link, $_POST['author']);
    $id = mysqli_real_escape_string($link, $_POST['id']);

    if ($author == '')
    {
        $error = 'Należy wybrać autora kawału.
                Kliknij powrót i spróbuj ponownie.';
        include 'error.html.php';
        exit();
    }

    $sql = "UPDATE kawal SET
            tekstkawalu='$text',
            idautora='$author'
            WHERE id='$id'";
    if (!mysqli_query($link, $sql))
    {
        $error = 'Błąd w trakcie uaktualniania kawału.';
        include 'error.html.php';
        exit();
    }

    $sql = "DELETE FROM kategoriakawalu WHERE idkawalu='$id'";
    if (!mysqli_query($link, $sql))
    {
        $error = 'Błąd w trakcie usuwania kategorii.';
        include 'error.html.php';
        exit();
    }

    if (isset($_POST['categories']))
    {
        foreach ($_POST['categories'] as $category)
        {
            $categoryid = mysqli_real_escape_string($link, $category);
            $sql = "INSERT INTO kategoriakawalu SET
                    idkawalu='$id',
                    idkategorii='$categoryid'";
            if (!mysqli_query($link, $sql))
            {
                $error = 'Błąd w trakcie wstawiania kawaÄąâ€šu do wybranej kategorii.';
                include 'error.html.php';
                exit();
            }
        }
    }

    header('Location: .');
    exit();
}

if (isset($_POST['action']) and $_POST['action'] == 'UsuÄąâ€ž')
{
    include $_SERVER['DOCUMENT_ROOT'] . '/includes/db.inc.php';
    $id = mysqli_real_escape_string($link, $_POST['id']);

    // UsuniĂ„â„˘cie przypisaÄąâ€ž kawaÄąâ€šu do kategorii
    $sql = "DELETE FROM kategoriakawalu WHERE idkawalu='$id'";
    if (!mysqli_query($link, $sql))
    {
        $error = 'Błąd w trakcie usuwania kawaÄąâ€šu z kategorii.';
        include 'error.html.php';
        exit();
    }

    // UsuniĂ„â„˘cie kawaÄąâ€šu
    $sql = "DELETE FROM kawal WHERE id='$id'";
    if (!mysqli_query($link, $sql))
    {
        $error = 'Błąd w trakcie usuwania kawaÄąâ€šu.';
        include 'error.html.php';
        exit();
    }

    header('Location: .');
    exit();
}

if (isset($_GET['action']) and $_GET['action'] == 'search')
{
    include $_SERVER['DOCUMENT_ROOT'] . '/includes/db.inc.php';

    // Podstawowe zapytanie SELECT
    $select = 'SELECT id, tekstkawalu';
    $from   = ' FROM kawal';
    $where  = ' WHERE TRUE';

    $authorid =  mysqli_real_escape_string($link, $_GET['author']);
    if ($authorid != '') // Wybrano autora
    {
        $where .= " AND idautora='$authorid'";
    }

    $categoryid =  mysqli_real_escape_string($link,
            $_GET['category']);
    if ($categoryid != '') // Wybrano kategoriĂ„â„˘
    {
        $from  .= ' INNER JOIN kategoriakawalu ON id = idkawalu';
        $where .= " AND idkategorii='$categoryid'";
    }

    $text = mysqli_real_escape_string($link, $_GET['text']);
    if ($text != '') // Podano fragment tekstu kawaÄąâ€šu
    {
        $where .= " AND tekstkawalu LIKE '%$text%'";
    }

    $result = mysqli_query($link, $select . $from . $where);
    if (!$result)
    {
        $error = 'Błąd w trakcie odczytywania kawałóww.';
        include 'error.html.php';
        exit();
    }

    while ($row = mysqli_fetch_array($result))
    {
        $jokes[] = array('id' => $row['id'], 'text' => $row['tekstkawalu']);
    }

    include 'jokes.html.php';
    exit();
}

// WyÄąâ€şwietlenie formularza wyszukiwania
include $_SERVER['DOCUMENT_ROOT'] . '/includes/db.inc.php';
$result = mysqli_query($link, 'SELECT id, nazwisko FROM autor');
if (!$result)
{
    $error = 'Błąd w trakcie pobierania autorów z bazy danych!';
    include 'error.html.php';
    exit();
}

while ($row = mysqli_fetch_array($result))
{
    $authors[] = array('id' => $row['id'], 'name' => $row['nazwisko']);
}

$result = mysqli_query($link, 'SELECT id, nazwa FROM kategoria');
if (!$result)
{
    $error = 'Błąd w trakcie pobierania kategorii z bazy danych!';
    include 'error.html.php';
    exit();
}

while ($row = mysqli_fetch_array($result))
{
    $categories[] = array('id' => $row['id'], 'name' => $row['nazwa']);
}

include 'searchform.html.php';
?>
