<?php
function oblicz_koszt_dostawy() {
  // ponieważ produkty wysyłane są na cały świat za pomocą
  // teleportacji, koszty dostawy są stałe
  return 20.00;
}

function pobierz_kategorie() {
   // zapytanie bazy danych o listę kategorii
   $lacz = lacz_bd();
   $zapytanie = "select idkat, nazwakat from kategorie";
   $wynik = @$lacz->query($zapytanie);
   if (!$wynik) {
      return false;
   }
   $ilosc_kat = @$wynik->num_rows;
   if ($ilosc_kat == 0) {
      return false;
   }
   $wynik = wynik_bd_do_tablicy($wynik);
   return $wynik;
}

function pobierz_nazwe_kategorii($idkat) {
   // zapytanie bazy danych o nazwę dla identyfikatora kategorii
   $idkat = intval($idkat);
   $lacz = lacz_bd();
   $zapytanie = "select nazwakat from kategorie
             where idkat = '".$lacz->real_escape_string($idkat)."'";
   $wynik = @$lacz->query($zapytanie);
   if (!$wynik) {
     return false;
   }
   $ilosc_kat = @$wynik->num_rows;
   if ($ilosc_kat == 0) {
      return false;
   }
   $rzad = $wynik->fetch_object();
   return $rzad->nazwakat;
}


function pobierz_ksiazki($idkat) {
   // zapytanie bazy danych o książki w danej kategorii
   if ((!$idkat) || ($idkat=='')) {
     return false;
   }

   $lacz = lacz_bd();
   $zapytanie = "select * from ksiazki where idkat='".$idkat."'";
   $wynik = @$lacz->query($zapytanie);
   if (!$wynik) {
     return false;
   }
   $ilosc_ksiazek = @$wynik->num_rows;
   if ($ilosc_ksiazek == 0) {
      return false;
   }
   $wynik = wynik_bd_do_tablicy($wynik);
   return $wynik;
}

function pobierz_dane_ksiazki($isbn) {
  // zapytanie bazy danych o wszystkie dane konkretnej książki
  if ((!$isbn) || ($isbn=='')) {
     return false;
  }

   $lacz = lacz_bd();
   $zapytanie = "select * from ksiazki where isbn='".$isbn."'";
   $wynik = @$lacz->query($zapytanie);
   if (!$wynik) {
     return false;
   }
   $wynik = @$wynik->fetch_assoc();
   return $wynik;
}

function oblicz_wartosc($koszyk) {
  // obliczenie całkowitej wartości produktów w koszyku
  $wartosc = 0.0;
  if(is_array($koszyk)) {
    $lacz = lacz_bd();
    foreach($koszyk as $isbn => $ilosc) {
      $zapytanie = "select cena from ksiazki where isbn='".$lacz->real_escape_string($isbn)."'";
      $wynik = $lacz->query($zapytanie);
      if ($wynik) {
        $produkt = $wynik->fetch_object();
        $cena_produktu = $produkt->cena;
        $wartosc +=$cena_produktu*$ilosc;
      }
    }
  }
  return $wartosc;
}

function oblicz_produkty($koszyk) {
  // obliczenie całkowitej ilości produktów w koszyku na zakupy
  $produkty = 0;
  if(is_array($koszyk)) {
      foreach($koszyk as $isbn => $ilosc) {
        $produkty += $ilosc;
      }
  }
  return $produkty;
}

?>