<?php

function tworz_naglowek_html($tytul) {
  // wyświetlenie nagłówka HTML
?>
<!doctype html>
  <html>
  <head>
    <meta charset="utf-8">
    <title><?php echo $tytul;?></title>
    <style>
      body { font-family: Arial, Helvetica, sans-serif; font-size: 13px }
      li, td { font-family: Arial, Helvetica, sans-serif; font-size: 13px }
      hr { color: #3333cc;}
      a { color: #000 }
      div.formblock
         { background: #ccc; width: 300px; padding: 6px; border: 1px solid #000;}
    </style>
  </head>
  <body>
  <div>
    <img src="zakladka.gif" alt="Logo ZakładkaPHP" height="55" width="57" style="float: left; padding-right: 6px;" />  
    <h1>ZakładkaPHP</h1>
  </div>
  <hr />  
<?php
  if($tytul) {
    tworz_tytul_html($tytul);
  }
}

function tworz_stopke_html() {
  // wyświetlenie stopki HTML
?>
  </body>
  </html>
<?php
}

function tworz_tytul_html($tytul) {
  // wyświetlenie tytułu
?>
  <h2><?php echo $tytul;?></h2>
<?php
}

function tworz_HTML_URL($url, $nazwa) {
  // wyświetlenie URL-a jako łącza i nowa linia
?>
  <br /><a href="<?php echo $url;?>"><?php echo $nazwa;?></a><br />
<?php
}

function wyswietl_informacje_witryny() {
  // wyświetlenie informacji marketingowych
?>
  <ul>
  <li>Przechowuj swoje zakładki online!
  <li>Zobacz, czego używają inni!
  <li>Podziel się swoimi ulubionymi stronami z innymi!
  </ul>
<?php
}

function wyswietl_form_log() {
?>
  <p><a href="formularz_rejestracji.php">Jeszcze nie członek?</a></p>
  <form method="post" action="czlonek.php">

  <div class="formblock">
    <h2>Logowanie członków:</h2>

    <p><label for="username">Nazwa użytkownika:</label><br/>
    <input type="text" name="nazwa_uz" id="nazwa_uz" /></p>

    <p><label for="passwd">Hasło:</label><br/>
    <input type="password" name="haslo" id="haslo" /></p>

    <button type="submit">Logowanie</button>

    <p><a href="zapomnij_formularz.php">Zapomniane hasło?</a></p>
  </div>

 </form>
<?php
}

function wyswietl_form_rej() {
?>
 <form method="post" action="nowa_rejestracja.php">

 <div class="formblock">
    <h2>Zarejestruj się już teraz</h2>

    <p><label for="email">Adres poczty elektronicznej:</label><br/>
    <input type="email" name="email" id="email" 
      size="30" maxlength="100" required /></p>

    <p><label for="nazwa_uz">Preferowana nazwa użytkownika <br />(maksymalnie 16 znaków):</label><br/>
    <input type="text" name="nazwa_uz" id="nazwa_uz" 
      size="16" maxlength="16" required /></p>

    <p><label for="haslo">Hasło <br />(pomiędzy 6 i 16 znaków):</label><br/>
    <input type="password" name="haslo" id="haslo" 
      size="16" maxlength="16" required /></p>

    <p><label for="haslo2">Potwierdź hasło:</label><br/>
    <input type="password" name="haslo2" id="haslo2" 
      size="16" maxlength="16" required /></p>


    <button type="submit">Rejestracja</button>

   </div>

  </form>
<?php

}

function wyswietl_urle_uzyt($tablica_url) {
  //wyswietlenie URL-i użytkownika

  // ustawienie zmiennej globalnej, aby możliwe było sprawdzanie strony
  global $tabela_zak;
  $tabela_zak = true;
?>
  <br />
  <form name="tabela_zak" action="usun_zak.php" method="post">
  <table width="300" cellpadding="2" cellspacing="0">
  <?php
  $kolor = "#cccccc";
  echo "<tr bgcolor=\"".$kolor."\"><td><strong>Zakładka</strong></td>";
  echo "<td><strong>Usuń?</strong></td></tr>";
  if ((is_array($tablica_url)) && (count($tablica_url) > 0)) {
    foreach ($tablica_url as $url) {
      if ($kolor == "#cccccc") {
        $kolor = "#ffffff";
      } else {
        $kolor = "#cccccc";
      }
      // należy pamiętać o wywołaniu htmlspecialchars() przy wyświetlaniu danych użytkownika
      echo "<tr bgcolor=\"".$kolor."\"><td><a href=\"".$url."\">".htmlspecialchars($url)."</a></td>
            <td><input type=\"checkbox\" name=\"usun_mnie[]\"
             value=\"".$url."\"/></td>
            </tr>";
      }
  } else {
    echo "<tr><td>Brak zapisanych zakładek</td></tr>";
  }
?>
  </table>
  </form>
<?php
}

function wyswietl_menu_uzyt() {
  // wyświetlenie menu opcji na stronie
?>
<hr />
<a href="czlonek.php">Strona główna</a> &nbsp;|&nbsp;
<a href="dodaj_zak_formularz.php">Dodaj zakładkę</a> &nbsp;|&nbsp;
<?php
  // opcja usuń jedynie w wypadku wyświetlenia tabeli zakładek
  global $tabela_zak;
  if($tabela_zak == true) {
    echo "<a href=\"#\" onClick=\"tabela_zak.submit();\">Usuń zakładki</a>&nbsp;|&nbsp;";
  } else {
    echo "<span style=\"color: #cccccc\">Usuń zakładki</span>&nbsp;|&nbsp;";
  }
?>
<a href="zmiana_hasla_formularz.php">Zmiana hasła</a><br />
<a href="rekomendacja.php">Zarekomenduj URL-e</a> &nbsp;|&nbsp;
<a href="wylog.php">Wylogowanie</a>
<hr />

<?php
}

function wyswietl_dodaj_zak_form() {
  // wyświetlenie formularza do dodania nowych zakładek
?>
<form name="tabela_zak" action="dodaj_zak.php" method="post">

 <div class="formblock">
    <h2>Nowa zakładka:</h2>

    <p>
    <input type="text" name="nowy_url" id="nowy_url" 
      size="40"  maxlength="255" value="http://" required /></p>

    <button type="submit">Dodaj zakładkę</button>

   </div>

</form>
<?php
}

function wyswietl_haslo_form() {
  // wyświetlenie formularza zmiany hasła
?>
   <br />
   <form action="zmiana_hasla.php" method="post">

 <div class="formblock">
    <h2>Zmiana hasła</h2>

    <p><label for="stare_haslo">Poprzednie hasło:</label><br/>
    <input type="password" name="stare_haslo" id="stare_haslo" 
      size="16" maxlength="16" required /></p>

    <p><label for="nowe_haslo">Nowe hasło:</label><br/>
    <input type="password" name="nowe_haslo" id="nowe_haslo" 
      size="16" maxlength="16" required /></p>

    <p><label for="nowe_haslo2">Powtorzenie nowego hasła:</label><br/>
    <input type="password" name="nowe_haslo2" id="nowe_haslo2" 
      size="16" maxlength="16" required /></p>


    <button type="submit">Zmiana hasła</button>

   </div>
   <br />
<?php
};

function wyswietl_zapomnij_form() {
  // wyświetlenie formularza HTML do ustawiania nowych haseł
?>
   <br />
   <form action="zapomnij_haslo.php" method="post">

   <div class="formblock">
    <h2>Zapomniałeś swojego hasła?</h2>

    <p><label for="nazwa_uz">Nazwa użytkownika:</label><br/>
    <input type="text" name="nazwa_uz" id="nazwa_uz" 
      size="16" maxlength="16" required /></p>

    <button type="submit">Zmiana hasła</button>

   </div>
   <br>
<?php
}

function wyswietl_rekomend_urle($tablica_url) {
  // wyniki podobne do wyswietl_urle_uzyt
  // zamiast wyświetlać URL-e użytkownika, wyświetla rekomendacje
?>
  <br />
  <table width="300" cellpadding="2" cellspacing="0">
<?php
  $kolor = "#cccccc";
  echo "<tr bgcolor=\"".$kolor."\">
        <td><strong>Rekomendacje</strong></td></tr>";
  if ((is_array($tablica_url) && count($tablica_url)>0)) {
    foreach ($tablica_url as $url) {
      if ($kolor == "#cccccc") {
        $kolor = "#ffffff";
      } else {
        $kolor = "#cccccc";
      }
      echo "<tr bgcolor=\"".$kolor."\">
            <td><a href=\"".$url."\">".htmlspecialchars($url)."</a></td></tr>";
    }
  } else {
    echo "<tr><td>Aktualnie brak rekomendacji.</td></tr>";
  }
?>
  </table>
<?php
}

?>
