<!DOCTYPE html>
<html>
<head>
  <title>"Książkorama"- Rezultaty wyszukiwania</title>
</head>
<body>
  <h1>"Książkorama"- Rezultaty wyszukiwania </h1>
  <?php
    // utworzenie krótkich nazw zmiennych
    $metoda_szukania=$_POST['metoda_szukania'];
    $wyrazenie="%{$_POST['wyrazenie']}%";

    if (!$metoda_szukania || !$wyrazenie) {
       echo '<p>Brak parametrów wyszukiwania. <br />
             Wróć do poprzedniej strony i spróbuj ponownie.</p>';
       exit;
    }

    // określenie typu wyszukiwania
    switch ($metoda_szukania) {
      case 'Tytul':
      case 'Autor':
      case 'ISBN':   
        break;
      default: 
        echo '<p>Nieprawidłowy typ wyszukiwania. <br/>
        Wróć i spróbuj jeszcze raz.</p>';
        exit; 
    }

    // konfiguracja połączenia z bazą przy użyciu  PDO
    $uzytkownik = 'ksiazkorama';
    $haslo = 'ksiazkorama123';
    $host = 'localhost';
    $nazwa_bazy = 'ksiazki';

    // koniguracja DSN
    $dsn = "mysql:host=$host;dbname=$nazwa_bazy";

    // nawiązanie połączenia z bazą danych
    try {
      $db = new PDO($dsn, $uzytkownik, $haslo); 

      // wykonanie zapytania
      $zapytanie = "SELECT ISBN, Autor, Tytul, Cena FROM Ksiazki WHERE $metoda_szukania = :szukanewyrazenie";  
      $polecenie = $db->prepare($zapytanie);  
      $polecenie->bindParam(':szukanewyrazenie', $wyrazenie);
      $polecenie->execute(); 

      // pobranie liczby zwróconych rekordów 
      echo "<p>Liczba znalezionych rekordów: ".$polecenie->rowCount()."</p>"; 

      // wyświetlenie każdego pobranego rekordu
      while($wynik = $polecenie->fetch(PDO::FETCH_OBJ)) {
        echo "<p><strong>Tytuł: ".$wynik->Tytul."</strong>";                               
        echo "<br />Autor: ".$wynik->Autor;                                              
        echo "<br />ISBN: ".$wynik->ISBN;                                                  
        echo "<br />Cena: ".number_format($wynik->Cena, 2)." zł</p>";                                         
      }         

      // zakończenie połączenia z bazą danych
      $db = NULL;
    } catch (PDOException $e) {
      echo "Błąd: ".$e->getMessage();
      exit;
    }
  ?>
</body>
</html>
