<?php
  include ('funkcje_ksiazka_kz.php');
  // koszyk na zakupy potrzebuje sesji, zostaje więc ona rozpoczęta
  session_start();

  $isbn = $_GET['isbn'];

  // pobranie książki z bazy danych
  $ksiazka = pobierz_dane_ksiazki($isbn);
  tworz_naglowek_html($ksiazka['tytul']);
  wyswietl_dane_ksiazki($ksiazka);

  // ustawienie URL-a dla przycisku „Konfiguracja”
  $cel = "indeks.php";
  if($ksiazka['idkat']) {
    $cel = "pokaz_kat.php?idkat=".urlencode($ksiazka['idkat']);
  }
  // jeżeli zalogowany jako administrator, pokaż łącze do edycji książki
  if(sprawdz_uzyt_admin()) {
    wyswietl_przycisk("edycja_ksiazki_form.php?isbn=".urlencode($isbn), "edycja-produktu", "Edycja Produktu");
    wyswietl_przycisk("admin.php", "menu-admin", "Menu administratora");
    wyswietl_przycisk($cel, "kontynuuj", "Kontynuacja");
  } else {
    wyswietl_przycisk("pokaz_kosz.php?nowy=".urlencode($isbn), "dodaj-do-koszyka", "Dodaj "
                   .htmlspecialchars($ksiazka['tytul'])." do koszyka na zakupy");
    wyswietl_przycisk($cel, "kontynuacja", "Kontynuacja zakupów");
  }

  tworz_stopke_html();
?>