<?php
session_start();
ob_start();
header("Content-type: application/json");

date_default_timezone_set('UTC');

// nawiązanie połączenia z bazą danych
$polaczenieBD = mysqli_connect('localhost', 'uzytkownik', 'haslo', 'czat');

if (mysqli_connect_errno()) {
   echo '<p>Błąd: Nie można nawiązać połączenia z bazą danych.<br/>
   Proszę spróbować później.</p>';
   exit;
}

try {
 
    $aktualnyCzas = time();
    $idSesji = session_id();
    
    $czasSprawdzenia = isset($_SESSION['czas_sprawdzenia']) ? 
                       $_SESSION['czas_sprawdzenia'] : $aktualnyCzas;
    
    $akcja = isset($_SERVER['REQUEST_METHOD']) && 
              ($_SERVER['REQUEST_METHOD'] == 'POST') ? 
              'wyslij' : 'pobierz';

    switch($akcja) {
        case 'pobierz':

          //echo 'SELECT * FROM wiadomosci_czatu WHERE data_utworzenia >= '. 
          //     $czasSprawdzenia. "  (". time() .") \n";

           $zapytanie = "SELECT * FROM wiadomosci_czatu WHERE data_utworzenia >= ?";

           $polecenie = $polaczenieBD->prepare($zapytanie);
           $polecenie->bind_param('s', $czasSprawdzenia);  
           $polecenie->execute();
           $polecenie->bind_result($id, $wiadomosc, $idSesji, $date_created);
           $wynik = $polecenie->get_result();

           $noweWiadomosci = [];
           while($wiadomosc = $wynik->fetch_assoc()) {
               
               if($idSesji == $wiadomosc['wyslana_przez']) {
                  $wiadomosc['wyslana_przez'] = 'ja';
               } else {
                  $wiadomosc['wyslana_przez'] = 'inny';
               }
             
               $noweWiadomosci[] = $wiadomosc;
            }


           $_SESSION['czas_sprawdzenia'] = $aktualnyCzas;

           print json_encode([
               'sukces' => true,
               'wiadomosci' => $noweWiadomosci
           ]);
           exit;

        case 'wyslij':

            $wiadomosc = isset($_POST['wiadomosc']) ? $_POST['wiadomosc'] : '';            
            $wiadomosc = strip_tags($wiadomosc);

            $zapytanie = "INSERT INTO wiadomosci_czatu (wiadomosc, wyslana_przez, data_utworzenia) 
                          VALUES(?, ?, ?)";

            $polecenie = $polaczenieBD->prepare($zapytanie);
            $polecenie->bind_param('ssi', $wiadomosc, $idSesji, $aktualnyCzas); 
            $polecenie->execute(); 

            print json_encode(['sukces' => true]);
            exit;
    }
} catch(\Exception $e) {
    print json_encode([
        'sukces' => false,
        'blad' => $e->getMessage()
    ]);
    
}
