<?php
  // sprawdzenie, czy dostępne są odpowiednie dane zmiennych
  // zmienne to tekst_przycisku oraz kolor

  $tekst_przycisku = $_POST['tekst_przycisku'];
  $kolor = $_POST['kolor'];

  if (empty($tekst_przycisku) || empty($kolor))
  {
    echo '<p>Stworzenie obrazka niemożliwe - formularz wypełniony niepoprawnie.</p>';
    exit;
  }

  // utworzenie obrazka o prawidłowym tle oraz sprawdzenie wielkości
  $ob = imagecreatefrompng($kolor.'-przycisk.png');

  $szerokosc_obrazka = imagesx($ob);
  $wysokosc_obrazka = imagesy($ob);

  // przyciski muszą mieć 18-pikselowy margines od krawędzi
  $szerokosc_obrazka_bez_marginesow = $szerokosc_obrazka - (2 * 18);
  $wysokosc_obrazka_bez_marginesow = $wysokosc_obrazka - (2 * 18);

  // Przekazanie GD2 informacji o miejscu, gdzie należy szukać czcionki

  // W przypadku systemu Windows będzie to:
  putenv('GDFONTPATH=C:\WINDOWS\Fonts'); 
  
  // Natomiast w przypadku systemu Unix należy podać pełną ścieżkę do katalogu czcionki.
  //putenv('GDFONTPATH=/usr/share/fonts/truetype/dejavu'); 
   
  // W tym przykładzie używana będzie czcionka Arial
  //$nazwa_czcionki = 'arial';
  $nazwa_czcionki = 'C:\WINDOWS\Fonts\arial.ttf';
  // W zależności od wersji biblioteki GD2 może być konieczne podanie ścieżki
  // dostępu do pliku czcionki bezpośrednio w argumencie wywołania funkcji
  // imagettfbox(). W takim przypadku należy ją określić w następujący sposób:
  // $nazwa_czcionki = 'C:\WINDOWS\Fonts\arial.ttf';

  // Obliczenie pasującego rozmiaru czcionki i odpowiednie jego zmniejszenie
  // Rozpoczęcie od największego rozmiaru, który intuicyjnie pasowałby do przycisków
  $rozmiar_czcionki = 33;

  do
  {
    $rozmiar_czcionki--;

    //obliczenie rozmiaru tekstu przy tym rozmiarze czcionki
    $bbox=imagettfbbox($rozmiar_czcionki, 0, $nazwa_czcionki, $tekst_przycisku);

    $tekst_prawy = $bbox[2];  //prawa współrzędna
    $tekst_lewy = $bbox[0];  //lewa współrzędna
    $szerokosc_tekstu = $tekst_prawy - $tekst_lewy; // jaki szeroki?
    $wysokosc_tekstu = abs($bbox[7] - $bbox[1]); // jaki wysoki?

  } while ($rozmiar_czcionki > 8 &&
          ($wysokosc_tekstu > $wysokosc_obrazka_bez_marginesow ||
           $szerokosc_tekstu > $szerokosc_obrazka_bez_marginesow)
         );

  if ($wysokosc_tekstu>$wysokosc_obrazka_bez_marginesow ||
      $szerokosc_tekstu>$szerokosc_obrazka_bez_marginesow)
  {
    // żaden możliwy do odczytania rozmiar czcionki nie pasuje
    echo '<p>Wprowadzony tekst nie pasuje do przycisku.</p>';
  }
  else
  {
    // odnaleziono pasujący rozmiar czcionki
    // teraz należy obliczyć jego współrzędne

    $tekst_x = $szerokosc_obrazka / 2.0 - $szerokosc_tekstu / 2.0;
    $tekst_y = $wysokosc_obrazka / 2.0 - $wysokosc_tekstu / 2.0;

    if ($tekst_lewy < 0)
    {
      $tekst_x += abs($tekst_lewy);  //Dodanie współczynnika do lewej pozycji
    }

    $nad_linia_tekstu = abs($bbox[7]); // jak wysoko nad podstawą?
    $tekst_y += $nad_linia_tekstu;  //dodanie współczynnika podstawy

    $tekst_y -= 2; // współczynnik dostosowania do kształtu szablonu

    $bialy = imagecolorallocate($ob, 255, 255, 255);

    imagettftext($ob, $rozmiar_czcionki, 0, $tekst_x, $tekst_y, $bialy, 
                 $nazwa_czcionki, $tekst_przycisku);

    header('Content-type: image/png');
    imagepng($ob);
  }

  // zwolnienie zasobów
  imagedestroy($ob);
?>  