<?php

// sprawdzenie, czy dysponujemy odpowiednimi danymi
$glos = $_POST['glos'];

if (empty($glos))
{
  echo '<p>Nie zagłosowałeś na nikogo.</p>';
  exit;
}

/***************************************************
  Zapytanie bazy danych odczytujące wynik ankiety
***************************************************/

// zalogowanie się w bazie danych
if (!$bd_polacz=new mysqli('localhost', 'ankieta', 'ankieta', 'ankieta'))
{
  echo '<p>Połączenie z bazą danych nieudane<br />
        Proszę spróbować później.</p>';
  exit;
}

mysqli_set_charset($bd_polacz,"utf8");  // połączenie z bazą używa UTF-8

// Rejestracja przesłanego głosu w bazie danych
$g_zapytanie = "UPDATE wyniki_ankiety 
                SET ilosc_glosow = ilosc_glosow + 1 
                WHERE kandydat = ?";
$g_polecenie = $bd_polacz->prepare($g_zapytanie);
$g_polecenie->bind_param('s', $glos);  
$g_polecenie->execute();
$g_polecenie->free_result();

// pobranie aktualnych wyników ankiety
$w_zapytanie = "SELECT kandydat, ilosc_glosow FROM wyniki_ankiety";
$w_polecenie = $bd_polacz->prepare($w_zapytanie);
$w_polecenie->execute();
$w_polecenie->store_result();
$w_polecenie->bind_result($kandydat, $ilosc_glosow);
$ilosc_kandydatow = $w_polecenie->num_rows;

// obliczenie całkowitej liczby głosów
$suma_glosow=0;

while ($w_polecenie->fetch())
{
    $suma_glosow += $ilosc_glosow;
}

$w_polecenie->data_seek(0); 

/*********************************************
  Początkowe obliczenia wykresu
*********************************************/
// ustawienie stałych
putenv('GDFONTPATH=C:\WINDOWS\Fonts');

$szerokosc = 500;         //szerokosc obrazka w pikselach
$lewy_margines = 70;      // miejsce pozostawiane po lewej stronie obrazka
$prawy_margines = 50;     // to samo dla strony prawej
$wysokosc_slupka = 40;
$odleglosc_slupkow = $wysokosc_slupka/2;
$czcionka = 'arial';
$czcionka = 'c:\windows\fonts\arial.ttf';
$rozmiar_tytulu = 16;     // w punktach
$rozmiar_podstawowy = 12; // w punktach
$rozmiar_maly = 12;       // w punktach
$wciecie_tekstu = 10;     //odległość lewych etykiet tekstowych od lewej krawędzi obrazka

// ustawienie początkowego punktu rysowania
$x = $lewy_margines + 60; //miejsce narysowania bazy wykresu
$y = 50;                  //to samo
$jednostka_slupka = ($szerokosc-($x+$prawy_margines)) / 100; //jeden "stopień" wykresu

// obliczenie wysokości wykresu - słupki plus przerwy plus pewien margines
$wysokosc = $ilosc_kandydatow * ($wysokosc_slupka + $odleglosc_slupkow) + 50;

/*********************************************
  Konfiguracja podstawowego obrazka
*********************************************/
// stworzenie pustego kadru
$ob = imagecreatetruecolor($szerokosc, $wysokosc);

// Przydzielenie kolorów
$bialy = imagecolorallocate($ob,255,255,255);
$niebieski = imagecolorallocate($ob,0,64,128);
$czarny = imagecolorallocate($ob,0,0,0);
$rozowy = imagecolorallocate($ob,255,78,243);

$kolor_tekstu = $czarny;
$kolor_procentow = $czarny;
$kolor_tla = $bialy;
$kolor_linii = $czarny;
$kolor_slupka = $niebieski;
$kolor_liczb = $rozowy;

// stworzenie "kadru" do rysowania
imagefilledrectangle($ob, 0, 0, $szerokosc, $wysokosc, $kolor_tla);

// narysowanie konturów wokół kadru
imagerectangle($ob, 0, 0, $szerokosc-1, $wysokosc-1, $kolor_linii);

// dodanie tytułu
$tytul = 'Wyniki ankiety';
$wymiary_tytulu = imagettfbbox($rozmiar_tytulu, 0, $czcionka, $tytul);
$dlugosc_tytulu = $wymiary_tytulu[2] - $wymiary_tytulu[0];
$wysokosc_tytulu = abs($wymiary_tytulu[7] - $wymiary_tytulu[1]);
$tytul_nad_linia = abs($wymiary_tytulu[7]);
$tytul_x = ($szerokosc - $dlugosc_tytulu)/2; // wyśrodkowanie w x
$tytul_y = ($y - $wysokosc_tytulu)/2 + $tytul_nad_linia; // wyśrodkowanie w y

imagettftext($ob, $rozmiar_tytulu, 0, $tytul_x, $tytul_y,
             $kolor_tekstu, $czcionka, $tytul);

// narysowanie bazy od nieco ponad pozycją pierwszego słupka do nieco
// poniżej pozycji ostatniego
imageline($ob, $x, $y-5, $x, $wysokosc-15, $kolor_linii);

/*********************************************
  Umieszczenie danych na wykresie
*********************************************/
// Pobranie każdego wiersza bazy danych i narysowanie odpowiadających im słupków

while ($w_polecenie->fetch())
{

  if ($suma_glosow > 0) {
    $procent = intval(round(($ilosc_glosow/$suma_glosow)*100));
  } else {
    $procent = 0;
  }

  // wyświetlenie procentów dla tej wartości
  $wymiary_procentow = imagettfbbox($rozmiar_podstawowy, 0, $czcionka, $procent.'%');

  $dlugosc_procentow = $wymiary_procentow[2] - $wymiary_procentow[0];

  imagettftext($ob,$rozmiar_podstawowy, 0, $szerokosc-$dlugosc_procentow-$wciecie_tekstu,
               $y+($wysokosc_slupka/2), $kolor_procentow, $czcionka, $procent.'%');

  // długość słupka dla tej wartości
  $dlugosc_slupka = $x + ($procent * $jednostka_slupka);

  // narysowanie słupka dla tej wartości
  imagefilledrectangle($ob, $x, $y-2, $dlugosc_slupka, $y+$wysokosc_slupka, $kolor_slupka);

  // narysowanie tytułu dla tej wartości
  imagettftext($ob, $rozmiar_podstawowy, 0, $wciecie_tekstu,
               $y+($wysokosc_slupka/2), $kolor_tekstu, $czcionka, $kandydat);

  // narysowanie konturu pokazującego 100%
  imagerectangle($ob, $dlugosc_slupka+1, $y-2, ($x+(100*$jednostka_slupka)),
                 $y+$wysokosc_slupka, $kolor_linii);

  // wyświetlenie liczb
  imagettftext($ob, $rozmiar_maly, 0, $x+(100*$jednostka_slupka)-50,
               $y+($wysokosc_slupka/2), $kolor_liczb, $czcionka,
               $ilosc_glosow.'/'.$suma_glosow);

  // przesunięcie do następnego słupka
  $y = $y+($wysokosc_slupka+$odleglosc_slupkow);
}

/*********************************************
  Wyświetlenie obrazka
*********************************************/
header('Content-type:  image/png');
imagepng($ob);

/*********************************************
  Zwalnianie zasobów
*********************************************/
$w_polecenie->free_result();
$bd_polacz->close();
imagedestroy($ob);
?>
