<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8" />
  <title>Uaktualnienie kopii lustrzanej</title>
</head>
<body>
  <h1>Uaktualnienie kopii lustrzanej</h1>

<?php
  // ustawienie zmiennych - należy je zmienić, aby pasowały do aplikacji
  $komp = 'apache.cs.utah.edu';
  $uzytkownik = 'anonymous';
  $haslo = 'ja@przyklad.com';
  $plikzdalny = '/apache.org/httpd/httpd-2.4.16.tar.gz';
  $pliklokalny = '/sciezka/do/plikow/httpd-2.4.16.tar.gz';

  // łączenie z komputerem
  $lacz=ftp_connect($komp);
   
  if(!$lacz)
  {
    echo 'Błąd: Nie można nawiązać połączenia z komputerem '. $komp;
    exit;
  }
  
  echo 'Połączono z '. $komp.'<br />';

  // logowanie do komputera
  $wynik = @ftp_login($lacz, $uzytkownik, $haslo);
  if (!$wynik)
  {
    echo 'Błąd: Nie można zalogować się jako '.$uzytkownik;
    ftp_quit($lacz);
    exit;
  }
  
  echo 'Zalogowano jako '.$uzytkownik.'<br />';

  // włączenie trybu pasywnego
  ftp_pasv($conn, true); 

  // sprawdzenie dat plików w celu określenia konieczności uaktualnienia
  echo 'Sprawdzanie daty pliku...<br />';
  if(file_exists($pliklokalny))
  {
    $czaslokalny=filemtime($pliklokalny);
    echo 'Plik lokalny zmodyfikowany';
    echo date('G:i j-M-Y', $czaslokalny);
    echo '<br />';
  }
  else
  {
    $czaslokalny=0;
  }

  $czaszdalny=ftp_mdtm($lacz, $plikzdalny);
  if (!($czaszdalny >= 0))
  {
    // To nie oznacza, że plik nie istnieje, serwer może nie dostarczać czasu modyfikacji
    echo 'Dostęp do czasu pliku zdalnego niemożliwy.<br />';
    $czaszdalny=$czaslokalny+1; //zapewnienie uaktualnienia
  }
  else
  {
    echo 'Plik zdalny zmodyfikowany ';
    echo date('G:i j-M-Y', $czaszdalny);
    echo '<br />';
  }
  
  if(!($czaszdalny > $czaslokalny))
  {
    echo 'Kopia lokalna jest aktualna.<br />';
    exit;
  }

  // pobieranie pliku
  echo 'Pobieranie pliku z serwera...<br />';
  $wp=fopen($pliklokalny, 'wb');

  if(!$sukces=ftp_fget($lacz, $wp, $plikzdalny, FTP_BINARY))
  {
    echo 'Błąd: pobranie pliku niemożliwe';
    fclose($wp);
    ftp_quit($lacz);
    exit;
  }

  fclose($wp);
  echo 'Plik pobrany pomyślnie';

  // zamknięcie połączenia z komputerem
  ftp_quit($lacz);

?>
</body>
<html>
