#! /usr/bin/php
<?php
// doczenie kodu wspuytkowanego
include '../lib/CommandLine.php';

// zdefiniowanie katalogu, w ktrym znajduje si szkielet struktury
define('SKEL_FILES', '/cieka/do/szkieletu/struktury');

// funkcja zwracajca numer wersji
function show_version()
{
    echo basename($_SERVER['argv'][0]) . ' version 1.0' . "\n";
}

// funkcja zwracajce instrukcj uycia skryptu
function show_help($display = true) 
{
    $script = basename($_SERVER['argv'][0]);
    $help =  <<<ENDHELP
Sposb uycia: {$skrypt} [OPCJE]
Tworzy katalog projektowy i kopiuje do niego podstawowe pliki.

-c, --copy-only      kopiuje szkielet projektu do katalogu docelowego, lecz
                     nie zastpuje elementw zastpczych i nie usuwa plikw .tmp
-h, --help           wywietla ten tekst pomocy i koczy wykonanie skryptu
-o, --output=TARGET  wskazuje katalog, do ktrego naley skopiowa pliki
-p, --preserve       zapobiega usuniciu plikw .tmp po zastpieniu elementw zastpczych
-v, --version        wywietla informacj o wersji i koczy wykonanie skryptu

ENDHELP;
    if ($display)
    {
        echo $help;
    }
    else
    {
        return $help;
    }
}

// funkcja, ktra rekurencyjnie kopiuje katalog; kod rdowy na podstawie
// kodu dostpnego pod adresem http://us2.php.net/manual/en/function.copy.php#77238
function dircopy_recurs($source, $dest)
{
    if (!$dir = opendir($source))
    {
        fwrite(STEDRR, 'BD: Nie mona otworzy ' . $source . "\n");
        exit(1);
    }

    while($file = readdir($dir))
    {
        if($file != '.' && $file != '..')
        {
            $path = $source . '/' . $file;

            // utworzenie katalogu i skopiowanie zawartoci
            if (is_dir($path))
            {
                if(!mkdir($dest . '/' . $file))
                {
                    fwrite(STDERR, 'BD: Nie mona utworzy katalogu ' .
                       $file . '.' . "\n");
                    exit(1);
                }
                dircopy_recurs($path, $dest . '/' . $file);
            }
            // skopiowanie plikw
            else if(is_file($path))
            {
                if(!copy($path, $dest . '/' . $file))
                {
                    fwrite(STDERR, 'BD: Nie mona skopiowa pliku ' . $file .
                        '.' . "\n");
                    exit(1);
                }
            }
        }
    }
    closedir($dir);
}

// nie podano argumentw
if ($_SERVER['argc'] == 1)
{
    fwrite(STDERR, show_help(false));
    exit(1);
}

// odczytanie argumentw z wiersza polece
else
{
    $allowed = array('c', 'copy-only', 'h', 'help', 'o', 'output', 
        'p', 'preserve', 'v', 'version');
    try
    {
        $options = CommandLine::parseOptions($_SERVER['argv'], $allowed);
    }
    catch (CommandLineOptionException $e)
    {
        fwrite(STDERR, $e->getMessage() . "\n" . show_help(false));
        exit(1);
    }
}

// wywietlenie pomocy w odpowiedzi na danie
if (isset($options['h']) || isset($options['help']))
{
    show_help();
    exit();
}

// wywietlenie informacji o wersji w odpowiedzi na danie
if (isset($options['v']) || isset($options['version']))
{
    show_version();
    exit();
}

// odczytanie katalogu docelowego
if (isset($options['o']) && isset($options['output']))
{
    fwrite(STDERR, 'BD: Nie odnaleziono katalogu docelowego.  Aby unikn ' . 
        'potencjalnych konfliktw ' . "\n" . 'naley uy opcji -o albo ' .
        '--output, nie obydwch naraz.' . "\n");
    exit(1);
}
else if (isset($options['o']) || isset($options['output']))
{
    $output = (isset($options['o'])) ? $options['o'] : $options['output'];
}
else
{
    fwrite(STDERR, 'BD: Nie wskazano lokalizacji docelowej przy uyciu opcji -o ' . 
        'lub --output.' . "\n");
    exit(1);
}

// ustalenie bezwzgldnej cieki do katalogu docelowego
$dir = basename($output);
$path = realpath(substr($output, 0, strlen($output) - strlen($dir)));

// ustalenie, czy mona utworzy katalog docelowy i czy katalog ju istnieje
clearstatcache();
if (!file_exists($path) || !is_dir($path) || !is_writable($path))
{
    fwrite(STDERR, 'BD: Katalog nadrzdny katalogu docelowego nie istnieje ' .
        "\n" . 'lub brak uprawnie do zapisywania w nim.' . "\n");
    exit(1);
}
if (file_exists($path . '/' . $dir))
{
    fwrite(STDERR, 'BD: Wskazany katalog docelowy ju istnieje.' . "\n");
    exit(1);
}

do
{
    // odczytanie danych konfiguracyjnych
    $db_host = CommandLine::promptDefault('Nazwa serwera bazy danych', 'localhost');
    $db_schema = CommandLine::promptDefault('Schemat bazy danych', 'TEST');
    $db_user = CommandLine::promptDefault('Uytkownik bazy danych', 'TESTUSR');
    $db_pass = CommandLine::prompt('Haso do bazy danych');
    $db_tbl_prefix = CommandLine::promptDefault('Prefiks tabel bazy danych', '');

    // weryfikcja poprawnoci wszystkich uzyskanych danych
    echo 'Struktura aplikacji zostanie utworzona na podstawie nastpujcych danych:' . "\n";
    echo str_repeat('-', 73) . "\n";
    echo 'Nazwa serwera bazy danych:  ' . $db_host . "\n";
    echo 'Schemat bazy danych:        ' . $db_schema . "\n";
    echo 'Uytkownik bazy danych:     ' . $db_user . "\n";
    echo 'Haso do bazy danych:       ' . $db_pass . "\n";
    echo 'Prefiks tabel bazy danych:  ' . $db_tbl_prefix . "\n";

    $ok = CommandLine::promptDefault('Wartoci s prawidowe?', 'tak', 3,
        'strtolower');
}
while ($ok != 'tak' && $ok != 't');
echo "\n";

// utworzenie katalogu docelowego
if (!mkdir($path . '/' . $dir))
{
    fwrite(STDERR, 'BD: Nie mona utworzy katalogu docelowego.' . "\n");
    exit(1);
}

// skopiowanie plikw szkieletu struktury do katalogu docelowego
dircopy_recurs(SKEL_FILES, $path . '/' . $dir);

// skojarzenie elementw zastpczych z wartociami podanymi przez uytkownika
// w celu ich zastpienia w plikach tymczasowych i zapisania jako elementy docelowe
if (!isset($options['c']) && !isset($options['copy-only']))
{
    $tags = array(
        '<tag::db_host>' => $db_host,
        '<tag::db_schema>' => $db_schema,
        '<tag::db_user>' => $db_user,
        '<tag::db_pass>' => $db_pass, 
        '<tag::db_tbl_prefix>' => $db_tbl_prefix);

    $files = array(
	       'lib/db.php.tmp');

    foreach ($files as $f)
    {
        $file_old = $path . '/' . $dir . '/' . $f;
        $file_new = substr($file_old, 0, -4);
        $newcontents = str_replace(array_keys($tags),
				    array_values($tags),
				    file_get_contents($file_old));
        if (!file_put_contents($file_new, $newcontents))
        {
            fwrite(STDERR, 'BD: Nie mona zapisa ' . $file_new . '.' . "\n");
            exit(1);
        }

        // usunicie plikw tymczasowych
        if (!isset($options['p']) && !isset($options['preserve']))
        {
            if (!unlink($file_old))
            {
                fwrite(STDERR, 'BD: Nie mona usun ' . $file_old . '.' .
                    "\n");
                fclose($fp);
                exit(1);
            }
        }
    }
}

echo 'Gratulacje!  Struktura projektu zostaa utworzona w ' . "\n" .
    $path . '/' . $dir . ".\n\n";
?>