<?php
// rozszerzenie klasy Exception o wasny typ wyjtku
class CommandLineOptionException extends Exception { }

class CommandLine
{
    // zdefiniowanie typw plikw konfiguracyjnych
    const CONFIG_TYPE_PLAIN = 1;
    const CONFIG_TYPE_INI = 2;

    // odczytanie tablicy z argumentami z wiersza polece
    // oraz opcjonalnej tablicy opcji dopuszczalnych i domylnych
    static public function parseOptions($args, $allowed = array())
    {
        $options = array();
        $count = count($args);

        // odczytanie argumentw i wypenienie tablicy $options
        for ($i = 1; $i < $count; $i++)
        {
            // odczytanie argumentw majacych posta --abc=foo
            if (preg_match('/^--([-A-Z0-9]+)=(.+)$/i', $args[$i], $matches))
            {
                if (empty($allowed) || in_array($matches[1], $allowed))
                {
                    $options[$matches[1]] = $matches[2];
                }
                else
                {
                    throw new CommandLineOptionException(
                        'Nieznana opcja ' . $matches[1]);
                }
            }

            // odczytanie argumentw --abc
            else if (substr($args[$i], 0, 2) == '--')
            {
                $tmp = substr($args[$i], 2);
                if (empty($allowed) || in_array($tmp, $allowed))
                {
                    $options[$tmp] = true;
                }
                else
                {
                    throw new CommandLineOptionException(
                        'Nieznana opcja ' . $tmp);
                }
            }

            // odczytanie argumentw -abc foo, -abc, -a foo oraz -a
            else if ($args[$i][0] == '-' && strlen($args[$i]) > 1)
            {
                // ustawienie wszystkich argumentw na true oprcz ostatniego w sekwencji
                for ($j = 1; $j < strlen($args[$i]) - 1; $j++)
                {
                    if (empty($allowed) || in_array($args[$i][$j], $allowed))
                    {
                        $options[$args[$i][$j]] = true;
                    }
                    else
                    {
                        throw new CommandLineOptionException(
                            'Nieznana opcja ' . $args[$i][$j]);
                    }
                }

                // ustawienie ostatniego argumentu w sekwencji
                $tmp = substr($args[$i], -1, 1);
                if (empty($allowed) || in_array($tmp, $allowed))
                {
                    // przypisanie wartoci nastpnego argumentu $args, jeeli istnieje
                    if ($i + 1 < $count && $args[$i + 1][0] != '-')
                    {
                        $options[$tmp] = $args[$i + 1];
                        $i++;
                    }
                    // przypisanie opcji jako wartoci logicznej
                    else
                    {
                        $options[$tmp] = true;
                    }
                }
                else
                {
                    throw new CommandLineOptionException(
                        'Nieznana opcja ' . $tmp);
                }
            }

            // nieprawidowy format opcji
            else
            {
                throw new CommandLineOptionException(
                    'Nieprawidowy format opcji ' . $args[$i]);
            }
        }

        return $options;
    }

    // przetworzenie pliku konfiguracyjnego i zwrcenie jego opcji w postaci tablicy
    static public function parseConfigFile($file, $type = CONFIG_TYPE_PLAIN)
    {
        $options = array();

        // przetworzenie zwykego pliku konfiguracyjnego
        if ($type == CONFIG_TYPE_PLAIN)
        {
            $fp = fopen($file, 'r');
            while (!feof($fp))
            {
                $line = trim(fgets($fp));
                // pominicie komentarzy i pustych wierszy
                if ($line && !preg('^#', $line))
                {
                    $pieces = explode('=', $line);
                    $opt = trim($pieces[0]);
                    $value = trim($pieces[1]);
    
                    $options[$opt] = $value;
                }
            }
            fclose($fp);
        }

        // przetworzenie pliku konfiguracyjnego ini
        else if ($type == CONFIG_TYPE_INI)
        {
            $options = parse_ini_file($file);
        }
        return $options;
    }

    // umoliwienie podania wartoci przez uytkownika, przyjcie opcjonalnej
    // maksymalnej dugoci danych wejciowych oraz funkcji wywoywanej zwrotnie
    static public function prompt($label, $length = 255, $callback = null)
    {
        echo $label . ': ';
        $value = trim(fread(STDIN, 255));
    
        return ($callback) ? call_user_func($callback, $value) : $value;
    }

    // umoliwienie podania wartoci przez uytkownika, przyjcie opcjonalnej wartoci
    // domylnej i maksymalnej dugoci danych wejciowych oraz funkcji wywoywanej zwrotnie
    static public function promptDefault($label, $default = null, 
        $length = 255, $callback = null)
    {
        $label .= ' [' . $default .']';
        $value = self::prompt($label, $length);

        if (!$value)
        {
            $value = $default;
        }
    
        return ($callback) ? call_user_func($callback, $value) : $value;
    }

}
?>