<?php
include '../lib/common.php';
include '../lib/db.php';
setlocale(LC_ALL, 'pl_PL', 'polish_pol');

// odczytanie elementw daty
list($full_month, $full_year, $short_month, $num_month, $short_year) =
    explode('/', strftime('%B/%Y/%b/%m/%y'));

?>
<html>
 <head>
  <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-2">
  <title>Statystyki witryny internetowej</title>
  <style type="text/css">
table {
    border-collapse: collapse;
}
th.blank {
    border: none;
}
th, td {
    text-align: center;
    vertical-align: top;
    border: 1px solid black;
    padding: 4px;
}
th.label {
    text-align: right;
}
  </style>
 </head>
 <body>
  <h1>Statystyki witryny internetowej</h1>
  <table>
   <tr>
    <th class="blank"> </th>
    <th>Miesic biecy (<?php echo $short_month . ' ' . $short_year; ?>)</th>
    <th>Od pocztku roku</th></th>
   </tr>
<?php
// odczytanie unikatowych adresw IP dla biecego miesica
$query = sprintf('
    SELECT
        INET_NTOA(IP_ADDRESS) AS IP_ADDRESS
    FROM 
        %sSITE_ACCESS SA
    WHERE
        DATE(ACCESS_TIME) BETWEEN
            "%d-%02d-01" AND  
            "%d-%02d-01" + INTERVAL 1 MONTH - INTERVAL 1 DAY
    GROUP BY
        SA.IP_ADDRESS
    ORDER BY
        COUNT(IP_ADDRESS) DESC',
    DB_TBL_PREFIX,
    $full_year,
    $num_month,
    $full_year,
    $num_month);
$result = mysql_query($query, $GLOBALS['DB']);

// czna liczba adresw
$mo_total = mysql_num_rows($result);

// dziesi pierwszych adresw IP ze zbioru wynikw
for ($i = 0; $i < 10 && $i < $mo_total; $i++)
{
    $row = mysql_fetch_assoc($result);
    $mo_addrs[] = $row['IP_ADDRESS'];
}
mysql_free_result($result);

// odczytanie unikatowych adresw IP dla biecego roku
$query = sprintf('
    SELECT
        INET_NTOA(IP_ADDRESS) AS IP_ADDRESS 
    FROM 
        %sSITE_ACCESS
    WHERE
        DATE(ACCESS_TIME) BETWEEN
            "%d-01-01" AND 
            "%d-01-01" + INTERVAL 1 YEAR - INTERVAL 1 DAY
    GROUP BY
        IP_ADDRESS 
    ORDER BY
        COUNT(IP_ADDRESS) DESC',
    DB_TBL_PREFIX,
    $full_year,
    $full_year);
$result = mysql_query($query, $GLOBALS['DB']);

// czna liczba adresw
$yr_total = mysql_num_rows($result);

// dziesi pierwszych adresw IP ze zbioru wynikw
for ($i = 0; $i < 10 && $i < $yr_total; $i++)
{
    $row = mysql_fetch_assoc($result);
    $yr_addrs[] = $row['IP_ADDRESS'];
}
mysql_free_result($result);
?>
   <tr>
    <th class="label">Liczba unikatowych uytkownikw</th>
    <td><?php echo $mo_total;?></td>
    <td><?php echo $yr_total;?></td>
   </tr><tr>
    <th class="label">10 najbardziej aktywnych adresw IP</th>
    <td><?php foreach ($mo_addrs as $addr) echo $addr . '<br/>';?></td>
  <td><?php foreach ($yr_addrs as $addr) echo $addr . '<br/>';?></td>
   </tr>
<?php
// odczytanie piciu stron najczciej odwiedzanych w biecym miesicu
$query = sprintf('
    SELECT
        REQ_PAGE, COUNT(REQ_PAGE) AS TOTAL
    FROM
        %sSITE_ACCESS
    WHERE
        DATE(ACCESS_TIME) BETWEEN
            "%d-%02d-01" AND
            "%d-%02d-01" + INTERVAL 1 MONTH - INTERVAL 1 DAY
    GROUP BY
        REQ_PAGE 
    ORDER BY
        TOTAL DESC
    LIMIT 5',
    DB_TBL_PREFIX,
    $full_year,
    $num_month, 
    $full_year,
    $num_month);
$result = mysql_query($query, $GLOBALS['DB']);

// zebranie stron ze zbioru wynikw
while ($row = mysql_fetch_assoc($result))
{
    $mo_pages_most[] = $row['REQ_PAGE'];
}
mysql_free_result($result);

// odczytanie piciu stron najczciej odwiedzanych w biecym roku
$query = sprintf('
    SELECT
        REQ_PAGE, COUNT(REQ_PAGE) AS TOTAL
    FROM
        %sSITE_ACCESS
    WHERE
        DATE(ACCESS_TIME) BETWEEN
            "%d-01-01" AND  
            "%d-01-01" + INTERVAL 1 YEAR - INTERVAL 1 DAY
    GROUP BY
        REQ_PAGE
    ORDER BY
        TOTAL DESC
    LIMIT 5',
    DB_TBL_PREFIX,
    $full_year,
    $full_year);
$result = mysql_query($query, $GLOBALS['DB']);

// zebranie stron ze zbioru wynikw
while ($row = mysql_fetch_assoc($result))
{
    $yr_pages_most[] = $row['REQ_PAGE'];
}
mysql_free_result($result);
?>
   <tr>
    <th class="label">5 najpopularniejszych stron</th>
    <td><?php foreach ($mo_pages_most as $addr) echo $addr . '<br/>';?></td>
    <td><?php foreach ($yr_pages_most as $addr) echo $addr . '<br/>';?></td>
   </tr>
<?php
// odwrcenie porzdku sortowania i odczytanie piciu najmniej popularnych stron
$query = sprintf('
    SELECT
        REQ_PAGE, COUNT(REQ_PAGE) AS TOTAL
    FROM
        %sSITE_ACCESS
    WHERE
        DATE(ACCESS_TIME) BETWEEN
            "%d-%02d-01" AND 
            "%d-%02d-01" + INTERVAL 1 MONTH - INTERVAL 1 DAY
    GROUP BY
        REQ_PAGE
    ORDER BY
        TOTAL ASC
    LIMIT 5',
    DB_TBL_PREFIX,
    $full_year,
    $num_month,
    $full_year,
    $num_month);
$result = mysql_query($query, $GLOBALS['DB']);

// zebranie najmniej popularnych stron ze zbioru wynikw
while ($row = mysql_fetch_assoc($result))
{
    $mo_pages_least[] = $row['REQ_PAGE'];
}
mysql_free_result($result);

$query = sprintf('
    SELECT
        REQ_PAGE, COUNT(REQ_PAGE) AS TOTAL
    FROM
        %sSITE_ACCESS
    WHERE
        DATE(ACCESS_TIME) BETWEEN
            "%d-01-01" AND
            "%d-01-01" + INTERVAL 1 YEAR - INTERVAL 1 DAY
    GROUP BY
        REQ_PAGE 
    ORDER BY
        TOTAL ASC
    LIMIT 5',
    DB_TBL_PREFIX,
    $full_year,
    $full_year);
$result = mysql_query($query, $GLOBALS['DB']);

// zebranie najmniej popularnych stron
while ($row = mysql_fetch_assoc($result))
{
    $yr_pages_least[] = $row['REQ_PAGE'];
}
mysql_free_result($result);
?>
   <tr>
    <th class="label">5 najmniej popularnych stron</th>
    <td><?php foreach ($mo_pages_least as $addr) echo $addr . '<br/>';?></td>
    <td><?php foreach ($yr_pages_least as $addr) echo $addr . '<br/>';?></td>
   </tr>
  </table>

  <p><strong>Rozkad liczby wywoa w poszczeglnych miesicach roku 
   <?php echo $full_year; ?></strong></p>
  <p><img src="img/chart.php?month" alt="miesiczny rozkad wywoa"></p>
  <p><strong>Rozkad liczby wywoa w poszczeglnych dniach miesica <?php echo $full_month . ' ' .
    $full_year; ?></strong></p>
  <p><img src="img/chart.php?day" alt="dzienny rozkad wywoa"></p>
 </body>
</html>
