<?php
class PieChart
{
    private $center;  // rodek
    private $width;   // szeroko wykresu
    private $image;   // odwoanie do obrazka

    // inicjalizacja nowego obiektu
    public function __construct($width)
    {
        // utworzenie nowego obrazka
        $this->image = imagecreatetruecolor($width, $width);

        // ustalenie rodka obrazka
        $this->center = $width / 2;
        $this->width = $width;

        // wypenienie biel ta obrazka
        $white = imagecolorallocate($this->image, 0xFF, 0xFF, 0xFF);
        imagefill($this->image, 0,0, $white);
    }

    // zwrcenie obrazka do przegldarki lub zapisanie w pliku
    public function flushImage($filename = '')
    {
        if ($filename)
        {
            imagepng($this->image, $filename);
        }
        else
        {
            header('Content-type: image/png');
            imagepng($this->image);
        }
    }

    // umieszczenie danych na wykresie przy uyciu wskazanych kolorw
    public function graphData($data, $colors)
    {
        // alokacja koloru czarnego jako koloru oddzielajcego segmenty danych
        $black = imagecolorallocate($this->image, 0x00, 0x00, 0x00);
    
        // suma wszystkich wartoci
        $sum = array_sum($data);
    
        // pocztkowy kt segmentu danych
        $start = -90;
    
        for ($i = 0; $i < count($data); $i++)
        {
            $color = imagecolorallocate($this->image, $colors[$i]['r'],
                $colors[$i]['g'], $colors[$i]['b']);
    
            // kocowy kt segmentu danych
            $stop = (100 * $data[$i] / $sum * 3.6) + $start;
    
            // dwukrotne wyrysowanie uku - jednego dla obszaru wypenionego kolorem i drugiego dla linii konturu
            imagefilledarc($this->image, $this->center, $this->center,
                $this->width, $this->width, $start, $stop, $color,
                IMG_ARC_PIE);
            imagefilledarc($this->image, $this->center, $this->center,
                $this->width, $this->width, $start, $stop, $black,
                IMG_ARC_NOFILL | IMG_ARC_EDGED);
    
            // przejcie do nastpnego punktu pocztku uku
            $start = $stop;
        }
    }
}

$data = array(150, 302, 250);
$colors = array(
    array('r' => 0x33, 'g' => 0xCC, 'b' => 0xFF),
    array('r' => 0xFF, 'g' => 0x33, 'b' => 0xCC),
    array('r' => 0xCC, 'g' => 0xFF, 'b' => 0x33));

$chart = new PieChart(150);
$chart->graphData($data, $colors);
$chart->flushImage();
?>