<?php
class BarChart
{
    private $width;   // szeroko wykresu
    private $height;  // wysoko wykresu
    private $image;   // odwoanie do obrazka
    private $black;   // zaalokowany czarny kolor

    // inicjalizacja nowego obiektu
    public function __construct($width, $height)
    {
        // utworzenie nowego obrazka
        $this->image = imagecreatetruecolor($width, $height);
        $this->width = $width;
        $this->height = $height;

        // wypenienie ta obrazka biaym kolorem
        $white = imagecolorallocate($this->image, 0xFF, 0xFF, 0xFF);
        imagefill($this->image, 0,0, $white);

        // wykrelenie osi
        $this->black = imagecolorallocate($this->image, 0x00, 0x00, 0x00);
        imageline($this->image, 20, 0, 20, $height - 20, $this->black);
        imageline($this->image, 20, $height - 20, $width - 20, $height - 20,
            $this->black);
    }

    // zwrcenie obrazka do przegldarki lub zapisanie w pliku
    public function flushImage($filename = '')
    {
        if ($filename)
        {
            imagepng($this->image, $filename);
        }
        else
        {while (@ob_end_clean());
            header('Content-type: image/png');
            imagepng($this->image);
        }
    }

    // wyrysowanie danych przy uyciu wskazanych kolorw i etykiet
    public function graphData($data, $colors, $labels)
    {
        // punkt pocztkowy
        $x = 20;
        $y = $this->height - 20;

        // obliczenie szerokoci supka
        $bar_width = ($this->width - $x - 20) / count($data);

        $ymax = max($data);

        foreach ($data as $i => $dat)
        {
            // obliczenie wysokoci supka
            $bar_height = ($dat / $ymax) * ($this->height - 30);
            $color = imagecolorallocate($this->image, $colors[$i]['r'],
                $colors[$i]['g'], $colors[$i]['b']);

            // dwukrotne wyrysowanie supka - najpierw dla obszaru wypenionego, potem dla konturu
            imagefilledrectangle($this->image, $x, $y, $x + $bar_width,
                $y - $bar_height, $color);
            imagerectangle($this->image, $x, $y, $x + $bar_width,
                $y - $bar_height, $this->black);

            imagestring($this->image, 2, $x, $y, $labels[$i], $this->black);

            // przejcie do nastpnego punktu pocztkowego
            $x += $bar_width;
        }
    }
}
?>