<?php
include '../lib/common.php';
include '../lib/db.php';
include '../lib/ShoppingCart.php';

// utworzenie lub przywrcenie sesji i pozyskanie koszyka na zakupy
session_start();
if (isset($_SESSION['cart']))
{
    $cart = unserialize($_SESSION['cart']);
}
else
{
    $cart = new ShoppingCart(); 
}

// oprnienie koszyka i przekierowanie uytkownika do listy kategorii
if (isset($_GET['empty']))
{
    $cart->removeAll();
    $_SESSION['cart'] = serialize($cart);
    header('Location: shop.php');
    end();
}

// parametr item wskazuje, e naley doda lub usun towary
if (isset($_GET['item']))
{
    // sprawdzenie, czy wskazano prawidowy towar
    $query = sprintf('SELECT ITEM_ID FROM %sSHOP_INVENTORY WHERE ' . 
        'ITEM_ID = %d',
        DB_TBL_PREFIX,
        $_GET['item']);
    $result = mysql_query($query, $GLOBALS['DB']);

    if (mysql_num_rows($result))
    {
        $row = mysql_fetch_assoc($result);
        $item = $row['ITEM_ID'];
    
        // dodanie towaru do koszyka
        if (isset($_GET['add']))
        {
            $cart->addItem($item);
        }

        // usunicie towaru z koszyka
        else if (isset($_GET['remove']))
        {
            $cart->removeItem($item);
        }
    }
    mysql_free_result($result);

    // zapisanie koszyka w sesji i przekierowanie uytkownika do poprzedniej strony
    $_SESSION['cart'] = serialize($cart);
    header('Location: ' . htmlspecialchars($_SERVER['HTTP_REFERER']));
    exit();
}

// wywietlenie zawartoci koszyka
else
{
    // uaktualnienie iloci poszczeglnych towarw w koszyku
    if (isset($_GET['update']))
    {
        foreach ($_POST['qty'] as $item => $qty)
        {
            $cart->addItem($item, $qty);
        }
    }

    ob_start();

    echo '<h1>Twj koszyk na zakupy</h1>';
    echo '<p><a href="shop.php">Powrt do listy kategorii</a>';

    // sprawdzenie parametru category i skonstruowanie odpowiedniego cza powrotnego
    if (isset($_GET['category']))
    {
        $query = sprintf('SELECT CATEGORY_ID, CATEGORY_NAME FROM ' .
            '%sSHOP_CATEGORY WHERE CATEGORY_ID = %d',
        DB_TBL_PREFIX,
        $_GET['category']);
        $result = mysql_query($query, $GLOBALS['DB']);

        if (mysql_num_rows($result))
        {
            $row = mysql_fetch_assoc($result);
            echo ' / <a href="shop.php?category=' . $row['CATEGORY_ID'] . 
                '">Powrt do kategorii ' . $row['CATEGORY_NAME'] . '</a>';
        }
        mysql_free_result($result);
    }
    echo '</p>';

    if ($cart->isEmpty)
    {
        echo '<p><b>Twj koszyk jest pusty.</b></p>';
    }
    else
    {
        // wywietlenie cza oprniajcego koszyk
        echo '<p><a href="cart.php?empty">';
        echo '<img src="img/cartempty.gif" alt="Oprnienie koszyka"/></a></p>';

        // umieszczenie listy w formularzu, aby mona zmienia iloci towarw
        echo '<form method="post" action="cart.php?update';
        // jeeli do skryptu przekazano kategori i wczeniej zostaa ona zweryfikowana, 
        // kategoria zostanie doklejona do adresu URL i cze powrotne pozostanie dostpne
        if  (isset($row['CATEGORY_ID']))
        {
            echo '&category=' . $row['CATEGORY_ID'];
        }
        echo '">';

        // wywietlenie wszystkich towarw w koszyku i wyliczenie cznej ceny
        $total = 0;
        echo '<table>';
        echo '<tr><th>Produkt</th><th>Ilo</th><th>Cena</th><th>Razem</th></tr>';
        foreach ($cart->contents as $id => $qty)
        {
            $query = sprintf('SELECT ITEM_NAME, PRICE FROM %sSHOP_INVENTORY ' .
                'WHERE ITEM_ID = %d',
                DB_TBL_PREFIX, 
                $id);
            $result = mysql_query($query, $GLOBALS['DB']);
    
            $row = mysql_fetch_assoc($result);
            echo '<tr>';
            echo '<td><a href="shop.php?item=' . $id . '">' . $row['ITEM_NAME'] .
                '</a></td>';
            echo '<td><select name="qty[' . $id . ']">';
            for ($i=0; $i < 11; $i++)
            {
                echo '<option ';
                if ($i == $qty)
                {
                    echo 'selected="selected" ';
                }
                echo 'value="' . $i . '">' . $i . '</option>';
            
            }
            echo '</select>';
            echo '</td>';
            echo '<td>' . number_format($row['PRICE'], 2) . 'PLN</td>';
            echo '<td>' . number_format($row['PRICE'] * $qty, 2) . 'PLN</td>';
            echo '</tr>';
    
            $total += $row['PRICE'] * $qty;
            mysql_free_result($result);
        }
        echo '</table>';
        echo '<input type="submit" value="Zmie"/>';
        
        echo '<p>czna liczba produktw: ' . $cart->totalItems . '<br/>';
        echo 'czna liczba sztuk produktw: ' . $cart->totalQty . '</p>';
        echo '<p><b>czna cena: ' . number_format($total, 2) . 'PLN</b></p>';
    
        // wywietlenie cza do zakoczenia zakupw
        echo '<p><a href="checkout.php">';
        echo '<img src="img/checkout.gif" alt="Dokonaj zakupu"/></a></p>';
    }

    // zapisanie koszyka w sesji i wywietlenie strony
    $_SESSION['cart'] = serialize($cart);

    $GLOBALS['TEMPLATE']['content'] = ob_get_clean();
    include '../templates/template-page.php';
}
?>
