<?php
class POP3Client
{
    private $server;
    public $response;

    // inicjalizuje nowy obiekt klasy POP3Client
    public function __construct()
    {
        $this->server = null;
        $this->response = '';
    }

    // zwraca true, jeeli otrzymano odpowied +OK
    private function isOk()
    {
        return substr($this->response, 0, 3) == '+OK';
    }

    // otwiera poczenie z serwerem POP3
    public function connect($server, $port = 110)
    {
        if (!$this->server = @fsockopen('tcp://' . $server, 110))
        {
            return false;
        }

        $this->response = trim(fgets($this->server, 512));
        if (!$this->isOk())
        {
            fclose($this->server);
            return false;
        }
        return true;
    }

    // wysya do serwera polecenie USER
    public function user($username)
    {
        fwrite($this->server, 'USER ' . $username . "\r\n");
        $this->response = trim(fgets($this->server, 512));
        return $this->isOk();
    }

    // wysya do serwera polecenie PASS
    public function pass($password)
    {
        fwrite($this->server, 'PASS ' . $password . "\r\n");
        $this->response = trim(fgets($this->server, 512));
        return $this->isOk();
    }

    // wysya do serwera polecenie NOOP (odpowiedzi zawsze powinno by true;
    // inna odpowied wskazuje na powany problem z serwerem POP3!)
    public function noop()
    {
        fwrite($this->server, 'NOOP' . "\r\n");
        $this->response = trim(fgets($this->server, 512));
        return $this->isOk();
    }

    // wysya do serwera polecenie STAT
    public function _stat()
    {
        fwrite($this->server, 'STAT' . "\r\n");
        $this->response = trim(fgets($this->server, 512));
        return $this->isOk();
    }

    // wysya do serwera polecenie LIST; moe przyjmowa id wiadomoci
    public function _list()
    {
        if (func_num_args())
        {
            $args = func_get_args();
            fwrite($this->server, 'LIST ' . $args[0] . "\r\n");
            $this->response = trim(fgets($this->server, 512));
            if (!$this->isOk())
            {
                return false;
            }
            else
            {
                $message = explode(' ', $this->response);
                array_shift($message);  // pominicie +OK
                $message[1] = trim($message[1]);  // usunicie kocowych znakw \r\n
                return $message;
            }
        }
        else
        {
            fwrite($this->server, 'LIST' . "\r\n");
            $this->response = trim(fgets($this->server, 512));
            if (!$this->isOk())
            {
                return false;
            }
            else
            {
                $messages = array();
                while (($line = fgets($this->server, 512)) != '.' . "\r\n")
                {
                    list($id, $size) = explode(' ', $line);
                    $messages[$id] = trim($size);
                }
                return $messages;
            }
        }
    }

    // wysya do serwera polecenie RETR
    public function retr($id)
    {
        fwrite($this->server, 'RETR ' . $id . "\r\n");
        $this->response = trim(fgets($this->server, 512));
        if (!$this->isOk())
        {
            return false;
        }
        else
        {
            $message = '';
            while (($line = fgets($this->server, 512)) != '.' . "\r\n")
            {
                $message .= $line;
            }
            return $message;
        }
    }

    // wysya do serwera polecenie DELE
    public function dele($id)
    {
        fwrite($this->server, 'DELE ' . $id . "\r\n");
        $this->response = trim(fgets($this->server, 512));
        return $this->isOk();
    }

    // wysya do serwera polecenie RSET
    public function rset()
    {
        fwrite($this->server, 'RSET' . "\r\n");
        $this->response = trim(fgets($this->server, 512));
        return $this->isOk();
    }

    // wysya do serwera polecenie QUIT
    public function quit()
    {
        fwrite($this->server, 'QUIT' . "\r\n");
        $this->response = trim(fgets($this->server, 512));
        fclose($this->server);
        return $this->isOk();
    }
}
?>
