<?php
class JpegThumbnail
{
    public $width;  // maksymalna szeroko miniaturki obrazka
    public $height; // maksymalna wysoko miniaturki obrazka

    // inicjalizacja nowego obiektu miniaturki
    public function __construct($width = 50, $height = 50)
    {
        $this->width = $width;
        $this->height = $height;
        
    }
    // przyjmuje lokalizacj pliku rdowego i zwraca uchwyt do otwartego pliku
    // albo zapisuje plik na dysku, jeeli wskazano lokalizacj docelow
    public function generate($src, $dest = '')
    {
        // odczytanie aktualnych rozmiarw obrazka
        list($width, $height) = getimagesize($src);

        // sprawdzenie, czy konieczna jest zmiana rozmiaru
        if(($lowest = min($this->width / $width, $this->height / $height)) < 1)
        {
            $tmp = imagecreatefromjpeg($src);

            // zmiana rozmiaru
            $sm_width = floor($lowest * $width);
            $sm_height = floor($lowest * $height);
            $img = imagecreatetruecolor($sm_width, $sm_height);
            imagecopyresized($img, $tmp, 0,0, 0,0, $sm_width, $sm_height,
                $width, $height);
            imagedestroy($tmp);
        }
        // obrazek ju jest miniaturk, wic nie trzeba zmienia jego rozmiaru
        else
        {
            $img = imagecreatefromjpeg($src);         
        }
        
        // zapisanie na dysku albo zwrcenie uchwytu do otwartego pliku
        if ($dest)
        {
            imagejpeg($img, $dest, 100);
            imagedestroy($img);
        }
        else
        {
            return $img;
        }
    }
}
?>
