<?php
// doczenie kodu wspuytkowanego
include '../lib/config.php';

// udostpnienie uytkownikom tylko plikw znajdujcych si w albumach
$file = (isset($_GET['file'])) ? (BASEDIR . '/' . $_GET['file']) : '';
if ($file && strpos(realpath($file), BASEDIR) === 0 && file_exists($file))
{
    header('Content-Type: image/jpeg');
    // wygenerowanie miniaturki
    switch (substr($file, strrpos($file, '.') + 1))
    {
        // miniaturka dla obrazka jpeg
        case 'jpg':
        case 'jpeg':
            include '../lib/JpegThumbnail.php';
            $thumbnail = new JpegThumbnail();
            imagejpeg($thumb = $thumbnail->generate($file), '', 100);
            imagedestroy($thumb);
            break;

        // miniaturka dla klipu wideo QuickTime
        case 'mov':
            include '../lib/MovThumbnail.php';
            $thumbnail = new MovThumbnail();

            // odczytanie i ustalenie rozmiarw miniaturki
            $thumb = $thumbnail->generate($file);
            $width = imagesx($thumb);
            $height = imagesy($thumb);
            
            // odczytanie i ustalenie rozmiarw wskanika
            $icon = imagecreatefromjpeg('overlay.jpg');
            $icon_width = imagesx($icon);
            $icon_height = imagesy($icon);
                    
            // skopiowanie wskanika do prawego dolnego rogu miniaturki
            imagecopymerge($thumb, $icon, $width - $icon_width, 
                $height - $icon_height, 0, 0, $icon_width, $icon_height, 100); 
            
            imagejpeg($thumb, '', 100);
            imagedestroy($thumb);
            imagedestroy($icon);
            break;
    }
}
?>


<?php
?>

