<?php
include '../../lib/functions.php';

// naley utworzy lub kontynuowa sesj i zapisa cig znakw CAPTCHA
// w $_SESSION, by by dostpny w ramach innych wywoa
if (!isset($_SESSION))
{
    session_start();
    header('Cache-control: private');
}

// utworzenie obrazka o wymiarach 65x20 pikseli
$width = 65;
$height = 20;
$image = imagecreate(65, 20);

// wypenienie obrazka kolorem ta
$bg_color = imagecolorallocate($image, 0x33, 0x66, 0xFF);
imagefilledrectangle($image, 0, 0, $width, $height, $bg_color);

// pobranie losowego tekstu
$text = random_text(5);

// ustalenie wsprzdnych x i y do wyrodkowania tekstu
$font = 5;
$x = imagesx($image) / 2 - strlen($text) * imagefontwidth($font) / 2;
$y = imagesy($image) / 2 - imagefontheight($font) / 2;

// wypisanie tekstu na obrazku
$fg_color = imagecolorallocate($image, 0xFF, 0xFF, 0xFF);
imagestring($image, $font, $x, $y, $text, $fg_color);

// zapisanie cigu znakw CAPTCHA do pniejszego porwnania
$_SESSION['captcha'] = $text;

// zwrcenie obrazka
header('Content-type: image/png');
imagepng($image);

imagedestroy($image);
?>
