// rejestracja uchwytw zdarze i ustawienie widoku pocztkowego
window.onload = function()
{
    document.getElementById('cat_delete').onclick = warnCategoryDelete;
    document.getElementById('cat_cancel').onclick = resetCategoryForm;
    document.getElementById('cat_submit').onclick = submitCategoryForm;

    document.getElementById('item_delete').onclick = warnItemDelete;
    document.getElementById('item_cancel').onclick = resetItemForm;
    document.getElementById('item_submit').onclick = submitItemForm;

    resetCategoryForm();
}

// zresetowanie formularza kategorii
function resetCategoryForm()
{
    // udostpnienie wszystkich kontrolek
    document.getElementById('cat_name').disabled = false;
    document.getElementById('cat_delete').disabled = false;
    document.getElementById('cat_submit').disabled = false;
    document.getElementById('cat_cancel').disabled = false;

    // ukrycie skadowych formularzy
    document.getElementById('cat_form_tbl').style.display = 'none';
    document.getElementById('item_select_tbl').style.display = 'none';
    document.getElementById('item_form_tbl').style.display = 'none';

    // zresetowanie koloru ta przycisku zatwierdzajcego oraz opcji usuwania
    document.getElementById('cat_delete').checked = false;
    document.getElementById('cat_submit').style.backgroundColor = '';

    // wypenienie listy kategorii i jej wywietlenie
    retrieveCategorySelect();
    document.getElementById('cat_select_tbl').style.display = '';
}

// wypenienie listy kategorii przy uyciu AJAX
function retrieveCategorySelect()
{
    var url = 'inventory_process.php?retrieve_category_select&nocache=' +
        (new Date()).getTime();

    window.httpObj = createXMLHTTPObject();
    window.httpObj.onreadystatechange = function()
    {
        if (window.httpObj.readyState == 4)
        {
            document.getElementById('cat_select_cell').innerHTML =
                window.httpObj.responseText;

            // przypisanie licie uchwytu zdarzenia
            document.getElementById('cat_select').onchange = showCategoryForms;
        }
    }

    window.httpObj.open('GET', url, false);
    window.httpObj.send(null);
}

// wywietlenie formularza kategorii i w razie potrzeby take listy produktw
function showCategoryForms()
{
    // ukrycie listy kategorii
    document.getElementById('cat_select_tbl').style.display = 'none';

    var select = document.getElementById('cat_select');
    retrieveCategoryValues(select.options[select.selectedIndex].value);

    if (select.options[select.selectedIndex].value != 'new')
    {
        // wypenienie listy produktw danej kategorii i jej wywietlenie
        retrieveItemSelect(select.options[select.selectedIndex].value);
        document.getElementById('item_select_tbl').style.display = '';
    }

    document.getElementById('cat_form_tbl').style.display = '';
}

// wypenienie formularza kategorii przy uyciu AJAX
function retrieveCategoryValues(value)
{
    if (value == 'new')
    {
        // wyczyszczenie pl, jeeli tworzony jest nowy rekord
        document.getElementById('cat_name').value = '';
        document.getElementById('cat_delete_row').style.display = 'none';
    }
    else
    {
        var url = 'inventory_process.php?retrieve_category&id=' + value + 
            '&nocache=' + (new Date()).getTime();

        window.httpObj = createXMLHTTPObject();
        window.httpObj.onreadystatechange = function()
        {
            if (window.httpObj.readyState == 4)
            {
                var r = eval('(' + window.httpObj.responseText + ')');
                document.getElementById('cat_name').value = r.cat_name;
                document.getElementById('cat_delete_row').style.display = '';
            }
        }

        window.httpObj.open('GET', url, false);
        window.httpObj.send(null);
    }
}

// wyrnienie przycisku zapisywania, jeeli rekordy maj zosta usunite
function warnCategoryDelete()
{
    var btn = document.getElementById('cat_submit');
    if (document.getElementById('cat_delete').checked)
    {
        btn.style.backgroundColor = '#FF0000';
    }
    else
    {
        btn.style.backgroundColor = '';
    }
}

// zapisanie formularza kategorii przez AJAX
function submitCategoryForm()
{
    // ostrzeenie, jeeli rekord ma zosta usunity
    if (document.getElementById('cat_delete').checked)
    {
        if (!confirm('Usunicie kategorii spowoduje rwnie usunicie nalecych ' +
            'do niej produktw.  Usun kategori produktw?'))
        {
            return;
        }
    }

    // przygotowanie adresu url i danych
    var url = 'inventory_process.php?save_category&nocache=' +
        (new Date()).getTime(); 

    var select = document.getElementById('cat_select');
    var data = 'id=' + select.options[select.selectedIndex].value +
        '&name=' + escape(document.getElementById('cat_name').value);

    if (document.getElementById('cat_delete').checked)
    {
        data += '&delete=true';
    }

    window.httpObj = createXMLHTTPObject();
    window.httpObj.onreadystatechange = function()
    {
        if (window.httpObj.readyState == 4)
        {
            // zresetowanie formularza po wykonaniu zapisu
            resetCategoryForm();
        }
    }

    // ustawienie nagwkw i wysanie zawartoci
    window.httpObj.open('POST', url, false);
    window.httpObj.setRequestHeader('Content-type',
        'application/x-www-form-urlencoded');
    window.httpObj.setRequestHeader('Content-length', data.length);
    window.httpObj.setRequestHeader('Connection', 'close');
    window.httpObj.send(data);
}

// zresetowanie formularza produktu
function resetItemForm()
{
    // wyczenie wszystkich kontrolek formularza kategorii
    document.getElementById('cat_name').disabled = true;
    document.getElementById('cat_delete').disabled = true;
    document.getElementById('cat_submit').disabled = true;
    document.getElementById('cat_cancel').disabled = true;

    // ukrycie skadowych formularza
    document.getElementById('item_form_tbl').style.display = 'none';

    // zresetowanie koloru ta przycisku zapisu oraz opcji usuwania
    document.getElementById('item_delete').checked = false;
    document.getElementById('item_submit').style.backgroundColor = '';

    // wypenienie listy produktw i jej wywietlenie
    var select = document.getElementById('cat_select');
    retrieveItemSelect(select.options[select.selectedIndex].value);
    document.getElementById('item_select_tbl').style.display = '';
}

// wypenienie listy produktw z wybranej kategorii przez AJAX
function retrieveItemSelect(id)
{
    var url = 'inventory_process.php?retrieve_item_select&id=' + id +
        '&nocache=' + (new Date()).getTime();

    window.httpObj = createXMLHTTPObject();
    window.httpObj.onreadystatechange = function()
    {
        if (window.httpObj.readyState == 4)
        {
            document.getElementById('item_select_cell').innerHTML =
                window.httpObj.responseText;

            // przypisanie licie uchwytu zdarzenia
            document.getElementById('item_select').onchange = showItemForm;
        }
    }

    window.httpObj.open('GET', url, false);
    window.httpObj.send(null);
}

// wywietlenie formularza produktu
function showItemForm()
{
    var select = document.getElementById('item_select');

    // wypenienie listy produktw dla kategorii i jej wywietlenie
    retrieveItemValues(select.options[select.selectedIndex].value);

    // ukrycie listy produktw i wywietlenie formularza produktu
    document.getElementById('item_select_tbl').style.display = 'none';
    document.getElementById('item_form_tbl').style.display = '';
    document.getElementById('item_submit').style.backgroundColor = '';
}

// wypenienie formularza produktu przez AJAX
function retrieveItemValues(value)
{
    if (value == 'new')
    {
        // wyczyszczenie pl, jeeli tworzony jest nowy rekord
        document.getElementById('item_name').value = '';
        document.getElementById('item_description').value = '';
        document.getElementById('item_price').value = '';
        document.getElementById('item_image').value = '';
        document.getElementById('item_delete_row').style.display = 'none';
    }
    else
    {
        var url = 'inventory_process.php?retrieve_item&id=' + value + 
            '&nocache=' + (new Date()).getTime();

        window.httpObj = createXMLHTTPObject();
        window.httpObj.onreadystatechange = function()
        {
            if (window.httpObj.readyState == 4)
            {
                var r = eval('(' + window.httpObj.responseText + ')');
                document.getElementById('item_name').value = r.item_name;
                document.getElementById('item_description').value = 
                    r.item_description;
                document.getElementById('item_price').value = r.item_price;
                document.getElementById('item_image').value = r.item_image;
                document.getElementById('item_delete_row').style.display = '';
            }
        }

        window.httpObj.open('GET', url, false);
        window.httpObj.send(null);
    }
}

// wyrnienie przycisku zapisu, jeeli rekordy maj zosta usunite
function warnItemDelete()
{
    var btn = document.getElementById('item_submit');
    if (document.getElementById('item_delete').checked)
    {
        btn.style.backgroundColor = '#FF0000';
    }
    else
    {
        btn.style.backgroundColor = '';
    }
}

// zapisanie formularza produktu przez AJAX
function submitItemForm()
{
    // ostrzeenie, jeeli rekord ma zosta usunity
    if (document.getElementById('item_delete').checked)
    {
        if (!confirm('Produkt zostanie usunity z magazynu. ' +
            'Usun produkt?'))
        {
            return;
        }
    }

    // przygotowanie adresu url i danych
    var url = 'inventory_process.php?save_item&nocache=' +
        (new Date()).getTime();

    var i_select = document.getElementById('item_select');
    var c_select = document.getElementById('cat_select');
    var data = 'id=' + i_select.options[i_select.selectedIndex].value +
        '&name=' + escape(document.getElementById('item_name').value) +
        '&description=' +
            escape(document.getElementById('item_description').value) +
        '&price=' + document.getElementById('item_price').value +
        '&image=' + escape(document.getElementById('item_image').value) +
        '&cat_id=' + c_select.options[c_select.selectedIndex].value;

    if (document.getElementById('item_delete').checked)
    {
        data += '&delete=true';
    }

    window.httpObj = createXMLHTTPObject();
    window.httpObj.onreadystatechange = function()
    {
        if (window.httpObj.readyState == 4)
        {
            // zresetowanie formularza po wykonaniu zapisu
            resetItemForm();
        }
    }

    // ustawienie nagwkw i wysanie zawartoci
    window.httpObj.open('POST', url, false);
    window.httpObj.setRequestHeader('Content-type',
        'application/x-www-form-urlencoded');
    window.httpObj.setRequestHeader('Content-length', data.length);
    window.httpObj.setRequestHeader('Connection', 'close');
    window.httpObj.send(data);
}