<?php
include '../lib/common.php';
include '../lib/config.php';

// wicej informacji: http://us2.php.net/manual/en/function.filesize.php#77518
function size_human_read ($size)
{
    // Tylko format od bajtw do gigabajtw. Jeeli kogo sta na cze, ktrym mona
    // przesya pliki o rozmiarach mierzonych w terabajtach, to sta go rwnie na honorarium
    // za dostosowanie kodu funkcji do kolejnych rzdw wielkoci! :)
    $sizes = array('B', 'KB', 'MB', 'GB');

    $prev_s = end($sizes);
    foreach ($sizes as $s)
    {
        if ($size < 1024)
        {
            break;
        }
        if ($s != $prev_s)
        {
            $size /= 1024;
        }
    }
    if ($s == $sizes[0])
    {
        return sprintf('%01d %s', $size, $s);
    }
    else
    {
        return sprintf('%01.2f %s', $size, $s);
    }
}

// zwrcenie wiersza HTML do wywietlenia na licie plikw
function directory_row($file, $show_stats = true)
{
    // odczytanie informacji o $file
    $is_dir = is_dir($file);
    $info = stat($file);

    // zliczanie wierszy, aby zmienia styl wierszy parzystych i nieparzystych
    static $row_count;
    if (!isset($row_count))
    {
        $row_count = 1;
    }
    else
    {
        $row_count++;
    }

    ob_start();
    echo '<tr class="' . (($row_count % 2 == 0) ? 'even' : 'odd' ). 'row" ';

    // doczenie uchwytw JavaScript
    echo 'onmouseover="highlightTableRow(this)" ';
    echo 'onmouseout="unhighlightTableRow(this)" ';
    echo 'onclick="selectTableRow(\'' . basename($file) . '\', this);" ';
    echo '">';

    // wyznaczenie odpowiedniej ikony dla typu MIME
    echo '<td style="width:25px; text-align: center;">';
    echo '<img style="height: 16px; width: 16px;" src="img/';
    if ($is_dir && basename($file) == '..')
    {
        echo 'up';
    }
    else if ($is_dir)
    {
        echo 'dir';
    }
    else
    {
        $ext = substr($file, strrpos($file, '.') + 1);
        if (file_exists('img/' . $ext . '.gif'))
        {
            echo $ext;
        }
        else
        {
            echo 'unknown';
        }
    }
    echo '.gif" /></td>';

    // wywietlenie informacji o pliku
    echo '<td>' . basename($file) . '</td>';
    if ($show_stats)
    {
        echo '<td>';
        if ($is_dir)
        {
            echo '---';
        }
        else
        {
            echo size_human_read($info['size']);
        }
        echo '</td>';
        echo '<td>' . date('d-m-Y', $info['mtime']) . '</td>';
    }
    else
    {
        echo '<td>&nbsp;</td><td>&nbsp;</td>';
    }
    echo '</tr>';
    $r = ob_get_contents();
    ob_end_clean();

    return $r;
}

if (!isset($_GET['action'])) return;
switch ($_GET['action'])
{
    // zwrcenie tabeli HTML z zawartoci katalogu
    case 'list':

        // sprawdzenie, czy podano wszystkie niezbdne parametry
        if (!isset($_GET['dir'])) return;

        // uniemoliwienie wyjcia poza katalog gwny
        $directory = realpath(BASEDIR . $_GET['dir']);
        if (strpos($directory, BASEDIR) !== 0) return;

        $ds = array();  // katalogi
        $fs = array();  // pliki

        if($dir = opendir($directory))
        {
            while($file = basename(readdir($dir)))
            {
                if($file == '.' || $file == '..')
                {
                    continue;
                }

                if (is_dir($directory . '/' . $file))
                {
                    $ds[] = $file;
                }
                else if(is_file($directory . '/' . $file))
                {
                    $fs[] = $file;
                }
            }
            closedir($dir);
        }
        natcasesort($ds);  // sortowanie naturalne, bez wzgldu na wielko liter
        natcasesort($fs);
?>
 <table>
  <thead>
   <tr><th colspan="2">Plik/Folder</th><th>Rozmiar</th><th>Data</th></tr>
  </thead>
  <tbody>
<?php
        // pominicie .. dla katalogu gwnego
        if (BASEDIR == $directory)
        {
            if (count($ds))
            {
                echo directory_row($directory . '/' . array_shift($ds),
                    TYPE_DIRECTORY, true);
            }
            else if (count($fs))
            {
                echo directory_row($directory . '/' . array_shift($fs),
                    TYPE_FILE, true);
            }
        }
        else
        {
            echo directory_row('..', TYPE_DIRECTORY, false);
        }

        foreach ($ds as $d)
        {
            echo directory_row($directory . '/' . $d, TYPE_DIRECTORY);
        }
        foreach ($fs as $file)
        {
            echo directory_row($directory . '/' . $file, TYPE_FILE);
        }
?>
    </tbody>
   </table>
<?php
        break;

    // usunicie katalogu lub pliku
    case 'delete':
    
        // sprawdzenie, czy podano wszystkie niezbdne parametry
        if (!isset($_GET['dir']) || !isset($_GET['file']))
        {
            return;
        }
    
        // uniemoliwienie wyjcia poza katalog gwny
        $directory = realpath(BASEDIR . $_GET['dir']);
        if (strpos($directory, BASEDIR) !== 0)
        {
            return;
        }
    
        $target = $directory . '/' . $_GET['file'];
    
        if (file_exists($target))
        {
            if (is_dir($target) && @rmdir($target))
            {
                    echo 'OK';
            }
            else if (is_file($target) && @unlink($target))
            {
                echo 'OK';
            }
            else
            {
                echo 'ERROR';
            }
        }
        else
        {
            echo 'ERROR';
        }
        break;
    
    // zmiana nazwy katalogu lub pliku
    case 'rename':
    
        // sprawdzenie, czy podano wszystkie niezbdne parametry
        if (!isset($_GET['dir']) || !isset($_GET['oldfile']) ||
            !isset($_GET['newfile']))
        {
            return;
        }
    
        // uniemoliwienie wyjcia poza katalog gwny
        $directory = realpath(BASEDIR . $_GET['dir']);
        if (strpos($directory, BASEDIR) !== 0)
        {
            return;
        }
    
        $old = $directory . '/' . $_GET['oldfile'];
        $new = $directory . '/' . $_GET['newfile'];
    
        if (file_exists($old) && @rename($old, $new))
        {
            echo 'OK';
        }
        else
        {
            echo 'ERROR';
        }
        break;
    
    // utworzenie nowego katalogu
    case 'new':
    
        // sprawdzenie, czy podano wszystkie niezbdne parametry
        if (!isset($_GET['dir']) || !isset($_GET['name']))
        {
            return;
        }
    
        // uniemoliwienie wyjcia poza katalog gwny
        $directory = realpath(BASEDIR . $_GET['dir']);
        if (strpos($directory, BASEDIR) !== 0)
        {
            return;
        }
    
        $target = $directory . '/' . $_GET['name'];
    
        if (!file_exists($target) && @mkdir($target))
        {
            echo 'OK';
        }
        else
        {
            echo 'ERROR';
        }
        break;
    
    // zwrcenie informacji niezbdnych do otwarcia folderu lub pliku
    case 'open':
     
        // sprawdzenie, czy podano wszystkie niezbdne parametry
        if (!isset($_GET['dir']) || !isset($_GET['file']))
        {
            return;
        }
    
        // uniemoliwienie wyjcia poza katalog gwny
        $directory = realpath(BASEDIR . $_GET['dir']);
        if (strpos($directory, BASEDIR) !== 0)
        {
            return;
        }
    
        $target = $directory . '/' . $_GET['file'];
    
        if (file_exists($target))
        {
            if (is_file($target))
            {
                echo json_encode(array(
                    'retType' => 'file'));
            }
            else if (is_dir($target))
            {
                echo json_encode(array(
                    'retType' => 'directory',
                    'directory' => substr($target, strlen(BASEDIR))));
            }
        }
        break;
}
?>