// odczytanie wszystkich elementw wskazanej klasy
function getElementsByClass(search)
{
    var classElements = new Array();
    var els = document.getElementsByTagName('*');
    var pattern = new RegExp('(^|\\s)' + search + '(\\s|$)');

    for (var i = 0, j = 0; i < els.length; i++)
    {
        if (pattern.test(els[i].className))
        {
            classElements[j] = els[i];
            j++;
        }
    }

    return classElements;
}

// zaznaczenie wiersza
function selectTableRow(data, e)
{
    unselectTableRow();
    e.type = e.className;
    e.className = 'selectedRow';
    window.filename = data;
}

// usunicie zaznaczenia z wiersza
function unselectTableRow()
{
    for (i = 0, s = getElementsByClass('selectedRow'); i < s.length; i++)
    {
        s[i].className = s[i].type;
    }

    hideForms();
}

// wyrnienie wiersza tabeli po umieszczeniu na nim wskanika myszy
function highlightTableRow(e)
{
    if (e.className != 'selectedRow')
    {
        e.style.backgroundColor = '#C3C3FE';
    }
}

// usunicie wyrnienia, gdy wskanik myszy zostanie przeniesiony poza wiersz
function unhighlightTableRow(e)
{
    e.style.backgroundColor = '';
}

// rejestracja uchwytw zdarze i ustawienie widoku pocztkowego
window.onload = function()
{
    window.directory = '/';  // aktualnie przegldany katalog
    window.filename = '';    // aktualnie wybrany plik

    // uchwyty zdarze
    document.getElementById('btn_open').onclick = openSelected;

    document.getElementById('btn_new_folder').onclick = showNewFolder;
    document.getElementById('form_new_submit').onclick = doNewFolder;
    document.getElementById('form_new_reset').onclick = hideForms;

    document.getElementById('btn_upload').onclick = showUploadFile;
    document.getElementById('form_upload').target = 'my_iframe';
    document.getElementById('form_upload_submit').onclick = doUploadFile;
    document.getElementById('form_upload_reset').onclick = hideForms;

    document.getElementById('btn_rename').onclick = showRename;
    document.getElementById('form_rename_submit').onclick = doRename;
    document.getElementById('form_rename_reset').onclick = hideForms;

    document.getElementById('btn_delete').onclick = doDelete;

    // zaadowanie listy plikw
    refreshFilesList();
}

// wywietlenie listy plikw i katalogw
function refreshFilesList()
{
    hideForms();

    var url = 'process.php?action=list&dir=' + window.directory + '&nocache=' +
        (new Date()).getTime();

    window.httpObj = createXMLHTTPObject();
    window.httpObj.open('GET', url , true);

    window.httpObj.onreadystatechange = function()
    {
        if (window.httpObj.readyState == 4 && window.httpObj.responseText)
        {
            // wypenienie pl
            document.getElementById('file_datagrid').innerHTML =
                window.httpObj.responseText;

            window.filename = '';  // wybrany plik
        }
    }

    window.httpObj.send(null);
}

// ukrycie wszystkich formularzy wejciowych
function hideForms()
{
    document.getElementById('form_new').style.display = 'none';
    document.getElementById('form_rename').style.display = 'none';
    document.getElementById('form_upload').style.display = 'none';
}

// powiadomienie uytkownika o bdzie adowania pliku
function uploadFailed()
{
    alert('Nie udao si zaadowa pliku na serwer.');
    hideForms();
}

// wywietlenie formularza do adowania nowego pliku na serwer
function showUploadFile()
{
    hideForms();
    document.getElementById('form_upload').reset();
    document.getElementById('form_upload').style.display = '';
}

// ustawienie form_upload_directory (pozwolenie przegldarce
// na zatwierdzenie formularza)
function doUploadFile()
{
    document.getElementById('form_upload_directory').value = window.directory;
}

// wywietlenie formularza do tworzenia nowego folderu
function showNewFolder()
{
    hideForms();
    document.getElementById('form_new_name').value = '';
    document.getElementById('form_new').style.display = '';
}

// utworzenie nowego folderu
function doNewFolder()
{
    var url = 'process.php?action=new&dir=' + window.directory + '&name=' +
        document.getElementById('form_new_name').value + '&nocache=' +
        (new Date()).getTime();

    window.httpObj = createXMLHTTPObject();
    window.httpObj.open('GET', url , true);

    window.httpObj.onreadystatechange = function()
    {
        if (window.httpObj.readyState == 4 && window.httpObj.responseText)
        {
            if (window.httpObj.responseText == 'OK')
            {
                refreshFilesList();
            }
            else
            {
                alert('Nie udao si utworzy katalogu.');
            }
        }
    }

    window.httpObj.send(null);
    return false;
}

// wywietlenie formularza do zmiany nazwy pliku lub katalogu
function showRename()
{
    // nie mona zmieni nazwy katalogu nadrzdnego ani pliku, jeeli aden plik nie jest wybrany
    if (window.filename == '..' || window.filename == '')
    {
        return;
    }

    hideForms();
    document.getElementById('form_rename_name').value = window.filename;
    document.getElementById('form_rename').style.display = '';
}

// zmiana nazwy pliku lub katalogu
function doRename()
{
    var url = 'process.php?action=rename&dir=' + window.directory +
        '&oldfile=' + window.filename + '&newfile=' +
        document.getElementById('form_rename_name').value + '&nocache=' +
        (new Date()).getTime();

    window.httpObj = createXMLHTTPObject();
    window.httpObj.open('GET', url , true);

    window.httpObj.onreadystatechange = function()
    {
        if (window.httpObj.readyState == 4 && window.httpObj.responseText)
        {
            if (window.httpObj.responseText == 'OK')
            {
                refreshFilesList();
            }
            else
            {
                alert('Nie udao si zmieni nazwy.');
            }
        }
    }

    window.httpObj.send(null);
    return false;
}

// usunicie pliku lub katalogu
function doDelete()
{
    // nie mona usun katalogu nadrzdnego ani pliku, jeeli aden plik nie jest wybrany
    if (window.filename == '..' || window.filename == '')
    {
        return;
    }

    if (!confirm('Czy na pewno chcesz usun?'))
    {
        return;
    }

    var url = 'process.php?action=delete&dir=' + window.directory + '&file=' +
        window.filename + '&nocache=' + (new Date()).getTime();

    window.httpObj = createXMLHTTPObject();
    window.httpObj.open('GET', url , true);

    window.httpObj.onreadystatechange = function()
    {
        if (window.httpObj.readyState == 4 && window.httpObj.responseText)
        {
            if (window.httpObj.responseText == 'OK')
            {
                refreshFilesList();
            }
            else
            {
                alert('Nie udao si usun.');
            }
        }
    }

    httpObj.send(null);
}

// pobranie zaznaczonego pliku albo przejcie do wybranego katalogu
function openSelected()
{
    var url = 'process.php?action=open&dir=' + window.directory + '&file=' +
        window.filename + '&nocache=' + (new Date()).getTime();

    window.httpObj = createXMLHTTPObject();
    window.httpObj.open('GET', url , true);

    window.httpObj.onreadystatechange = function()
    {
        if (window.httpObj.readyState == 4 && window.httpObj.responseText)
        {
            var result = eval('(' + window.httpObj.responseText + ')');
            if (result.retType == 'directory')
            {
                window.directory = result.directory;
                refreshFilesList();
            }
            else if (result.retType == 'file')
            {
                window.location = 'download.php?&dir=' + window.directory +
                    '&file=' + window.filename + '&nocache=' +
                    (new Date()).getTime();
            }
            else
            {
                alert('Nieznany bd.');
            }
        }
    }

    window.httpObj.send(null);
    return false;
}
