<?php
// doczenie kodu wspuytkowanego
include '../lib/common.php';
include '../lib/db.php';
include '../lib/functions.php';
include '../lib/User.php';

// formularz HTML z daniem hasa
ob_start();
?>
<form action="<?php echo htmlspecialchars($_SEVER['PHP_SELF']); ?>"
 method="post">
<p>Podaj nazw uytkownika. Nowe haso zostanie wysane
na podany adres poczty email.</p>
<table>
<tr>
 <td><label for="username">Nazwa uytkownika</label></td>
 <td><input type="text" name="username" id="username"
  value="<?php if (isset($_POST['username']))
  echo htmlspecialchars($_POST['username']); ?>"/></td>
</tr><tr>
 <td> </td>
 <td><input type="submit" value="Zatwierd"/></td>
 <td><input type="hidden" name="submitted" value="1"/></td>
</tr><tr>
</table>
</form>
<?php
$form = ob_get_clean();

// wywietlenie formularza, jeli strona jest przegldana po raz pierwszy
if (!isset($_POST['submitted']))
{
    $GLOBALS['TEMPLATE']['content'] = $form;
}
// w przeciwnym razie - przetworzenie danych wejciowych
else
{
    // sprawdzenie poprawnoci nazwy uytkownika
    if (User::validateUsername($_POST['username']))
    {
        $user = User::getByUsername($_POST['username']);
        if (!$user->userId)
        {
            $GLOBALS['TEMPLATE']['content'] = '<p><strong>Przepraszamy, ' .
                'podane konto nie istnieje.</strong></p> <p>Prosimy poda ' .
                'inn nazw uytkownika.</p>';
            $GLOBALS['TEMPLATE']['content'] .= $form;
        }
        else
        {
            // wygenerowanie nowego hasa
            $password = random_text(8);

            // wysanie nowego hasa na adres pocztowy
            $message = 'Nowe haso to: ' . $password;
            mail($user->emailAddr, 'New password', $message);

            $GLOBALS['TEMPLATE']['content'] = '<p><strong>Nowe haso ' .
                'wysano na podany adres pocztowy.</strong></p>';

            // zapisanie nowego hasa
            $user->password = $password;
            $user->save();
        }
    }
    // dane bdne
    else
    {
        $GLOBALS['TEMPLATE']['content'] .= '<p><strong>Nie podano ' .
            'prawidowej nazwy uytkownika.</strong></p> <p>Prosimy ' .
            'sprbowa ponownie.</p>';
        $GLOBALS['TEMPLATE']['content'] .= $form;
    }
}

// wywietlenie strony
include '../templates/template-page.php';
?>
