<?php
    
    // Początkowo przyjmowane jest założenie, że transakcja się powiedzie
    $success = TRUE;
    
    // Zapisanie przesłanego identyfikatora w zmiennej 
    $itemID = filter_var($_POST['itemid'], FILTER_VALIDATE_INT);

    // Pobranie kupującego przy użyciu metod fikcyjnej klasy
    $participant = new Participant();
    $buyerID = $participant->getParticipantKey();
    
    // Pobranie sprzedającego oraz ceny produktu przy użyciu metod
    // fikcyjnej klasy
    $item = new Item();
    $sellerID = $item->getItemOwner($itemID);
    $price = $item->getPrice($itemID);

    // Utworzenie obiektu klasy mysqli 
    $db = new mysqli("localhost","internauta","tajne","chapter37");

    // Wyłączenie automatycznego zatwierdzania transakcji
    $db->autocommit(FALSE);

    // Obciążenie konta kupującego
    $stmt = $db->prepare("UPDATE participants SET cash = cash - ? WHERE id = ?");
    
    $stmt->bind_param('di', $price, $buyerID);
    
    $stmt->execute();
    if ($db->affected_rows != 1)
        $success = FALSE;
        
    // Powiększenie stanu konta sprzedającego
    $query = $db->prepare("UPDATE participants SET cash = cash + ? WHERE id = ?");
    
    $stmt->bind_param('di', $price, $sellerID);
    
    $stmt->execute();
    
    if ($db->affected_rows != 1)
        $success = FALSE;
    
    // Zmiana właściciela produktu. Jeśli nie uda się go zmienić,
    // zmiennej $success przypisywana jest wartość FALSE
    $stmt = $db->prepare("UPDATE trunks SET owner = ? WHERE id = ?");
    
    $stmt->bind_param('ii', $buyerID, $itemID);
    
    $stmt->execute();
    
    if ($db->affected_rows != 1)
        $success = FALSE;

    // Jeśli zmienna $success ma wartość TRUE, transkacja zostaje zatwierdzona
    // w przeciwnym razie zostaje wycofana
    if ($success) {
        $db->commit();
        echo "Zamiana wykonana! Gratulujemy!";
    } else {
        $db->rollback();
        echo "Problemy z zamianą!";
    }
    
?>