<?php
    require("Smarty.class.php");
    require("boxer.class.php");
    
    $smarty = new Smarty;
    
    $smarty->caching = 1;
    
    try {
    
        // Jeśli szablonu nie ma w pamięci podręcznej, to należy pobrać 
        // niezbędne informacje
        if (!is_cached("boxerbio.tpl", $_GET['boxerid'])) {
            $bx = new boxer();
            
            if (! $bx->retrieveBoxer($_GET['boxerid']) )
                throw new Exception("Nie znaleziono boksera.");
                
            // Utworzenie odpowiednich zmiennych dla szablonu
            $smarty->assign("name", $bx->getName());
            $smarty->assign("bio", $bx->getBio());
        }
        
        /* Wygenerowanie szablonu, zapisanie go w pamięci podręcznej 
         * i przypisanie nazwy określonej jako $_GET['boxerid']. Jeśli 
         * szablon jest dostępny w pamięci podręcznej, należy go pobrać
         */
        $smarty->display("boxerbio.tpl", $_GET['boxerid']);
        
    } catch (Exception $e) {
        echo $e->getMessage();
    }
?>
