<?php

function amortizationTable($pNum, $periodicPayment, $balance, $monthlyInterest)
{
    // Wyliczenie odsetek
    $paymentInterest = round($balance * $monthlyInterest, 2);
    
    // Określenie kwoty kapitału
    $paymentPrincipal = round($periodicPayment - $paymentInterest, 2);
    
    // Odliczenie kwoty kapitału od pozostałej wartości kredytu 
    $newBalance = round($balance - $paymentPrincipal, 2);
    
    // Jeśli nowa wartość kredytu < miesięcznej raty, przypisujemy jej zero
    if ($newBalance < $paymentPrincipal) {
        $newBalance = 0;
    }
    
    printf("<tr><td>%d</td>", $pNum);
    printf("<td>%s zł</td>", number_format($newBalance, 2));
    printf("<td>%s zł</td>", number_format($periodicPayment, 2));
    printf("<td>%s zł</td>", number_format($paymentPrincipal, 2));
    printf("<td>%s zł</td></tr>", number_format($paymentInterest, 2));

    # Jeśli nowa wartość jest różna od zera, to rekurencyjnie 
    # wywołujemy funkcję amortizationTable() 
    if ($newBalance > 0) {
        $pNum++;
        amortizationTable($pNum, $periodicPayment,
                          $newBalance, $monthlyInterest);
    } else {
        return 0;
    }
}


    // Kwota kredytu
    $balance = 10000.00;
    
    // Procent odsetek
    $interestRate = .0575;
    
    // Miesięczna, procentowa wartość odsetek 
    $monthlyInterest = $interestRate / 12;
    
    // Długość spłaty kredytu w latach
    $termLength = 5;
    
    // Liczba rat spłacanych w ciągu roku
    $paymentsPerYear = 12;
    
    // Numer raty
    $paymentNumber = 1;
    
    // Określenie całkowitej liczby spłacanych rat
    $totalPayments = $termLength * $paymentsPerYear;
    
    // Określenie odsetek dla raty miesięcznej 
    $intCalc = 1 + $interestRate / $paymentsPerYear;
    
    // Określenie wysokości raty miesięcznej
    $periodicPayment = $balance * pow($intCalc,$totalPayments) * ($intCalc - 1) /
                                      (pow($intCalc,$totalPayments) - 1);

    // Zaokrąglenie wartości miesięcznej raty do 2 miejsc po przecinku
    $periodicPayment = round($periodicPayment,2);
    
    // Create table
    echo "<table width='50%' align='center' border='1'>";
    echo "<tr>
          <th>Numer raty</th><th>Stan kredytu</th>
          <th>Rata</th><th>Suma kapitału</th><th>Odsetki</th>
          </tr>";
    // Rekurencyjne wywołanie funkcji
    amortizationTable($paymentNumber, $periodicPayment, $balance,
                      $monthlyInterest);
    
    // Koniec tabeli HTML
    echo "</table>";
?>
