<?php
    // Dołączenie pakietu HTML_Table
    require_once "HTML/Table.php";
    
    // Nawiązanie połączenia z bazą danych
    $mysqli = new mysqli("localhost", "internauta", "tajne", "corporate");
    
    // Utworzenie tablicy atrybutów
    $attributes = array('border' => '1');
    
    // Utworzenie obiektu tabeli
    $table = new HTML_Table($attributes);
    
    // Określenie nagłówków
    $table->setHeaderContents(0, 0, "ID zamówienia");
    $table->setHeaderContents(0, 1, "ID klienta");
    $table->setHeaderContents(0, 2, "Data zamówienia");
    $table->setHeaderContents(0, 3, "Wartość towarów");
    $table->setHeaderContents(0, 4, "Koszty przesyłki");
    $table->setHeaderContents(0, 5, "Wartość sumaryczna");
    
    // Utworzenie i wykonanie zapytania
    $query = "SELECT id AS `Order ID`, client_id AS `Client ID`,
              order_time AS `Order Time`,
              CONCAT(sub_total, ' zł') AS `Sub Total`,
              CONCAT(shipping_cost, ' zł') AS `Shipping Cost`,
              CONCAT(total_cost, ' zł') AS `Total Cost`
              FROM sales ORDER BY id";
              
    $stmt = $mysqli->prepare($query);

    $stmt->execute();

    $stmt->bind_result($orderID, $clientID, $time, $subtotal, $shipping, $total);

    // Zaczynamy do wiersza nr. 1, aby nie nadpisać nagłówka tabeli
    $rownum = 1;
    
    // Sformatowanie każdego z wierszy
    while ($stmt->fetch()) {
        
        $table->setCellContents($rownum, 0, $orderID);
        $table->setCellContents($rownum, 1, $clientID);
        $table->setCellContents($rownum, 2, $time);
        $table->setCellContents($rownum, 3, $subtotal);
        $table->setCellContents($rownum, 4, $shipping);
        $table->setCellContents($rownum, 5, $total);
        $rownum++;
    }
    
    // Wyświetlenie tabeli
    echo $table->toHTML();
    
    // Zamknięcie połączenia z bazą
    $mysqli->close();
    
?>    