<?php
// Source code example for Web Database Applications with PHP and MySQL, 2nd Edition
// Author: Hugh E. Williams, 2001-3
// 
// Unless otherwise stated, the source code distributed with this book can be
// redistributed in source or binary form so long as an acknowledgment appears
// in derived source files.
// The citation should list that the code comes from Hugh E. Williams and David 
// Lane, "Web Database Application with PHP and MySQL" published by O'Reilly & 
// Associates.
//
// This code is under copyright and cannot be included in any other book,
// publication, or educational product without permission from O'Reilly &
// Associates. No warranty is attached; we cannot take responsibility for errors 
// or fitness for use.

// Skrypt pozwala na wprowadzenie numeru karty kredytowej oraz 
// instrukcji dostawy.
// Uytkownik musi by zalogowany.

require_once "../includes/template.inc";
require_once "../includes/winestore.inc";
require_once "../includes/authenticate.inc";

set_error_handler("customHandler");

session_start();

// Kontrola, czy uytkownik jest prawidowo zalogowany.
sessionAuthenticate(S_SHOWCART);

// Wymaga jako parametrw nagwka, instrukcji, akcji, nazwy formVars
// oraz nazwy formErrors.
$template = new winestoreFormTemplate("Realizacja zamwienia", 
            "Prosz poda dane karty SurchargeCard " . 
            "(sprbuj: 8000000000001001 ) oraz instrukcji dostawy.",
            S_ORDER_2, "ccFormVars", "ccErrors");

// Tworzenie obowizkowych pl danych karty kredytowej.
$template->mandatoryWidget("creditcard", "Numer karty SurchargeCard:", 16);
$template->mandatoryWidget("expirydate", "Data wanoci (mm/rr):", 5);
$template->optionalWidget("instructions", "Instrukcje dostawy:", 128);

$template->showWinestore(SHOW_ALL, B_SHOW_CART | B_HOME);
?>
