<?php
// Source code example for Web Database Applications with PHP and MySQL, 2nd Edition
// Author: Hugh E. Williams, 2001-3
// 
// Unless otherwise stated, the source code distributed with this book can be
// redistributed in source or binary form so long as an acknowledgment appears
// in derived source files.
// The citation should list that the code comes from Hugh E. Williams and David 
// Lane, "Web Database Application with PHP and MySQL" published by O'Reilly & 
// Associates.
//
// This code is under copyright and cannot be included in any other book,
// publication, or educational product without permission from O'Reilly &
// Associates. No warranty is attached; we cannot take responsibility for errors 
// or fitness for use.

// Skrypt pozwala na dodanie towaru do koszyka.
// Oczekuje on identyfikatora wina - WineId oraz iloci (qty) 
// dodawanego wina.

require_once "DB.php";
require_once "../includes/winestore.inc";

set_error_handler("customHandler");

// Czy zostay podane prawidowe parametry?
if (empty($_GET["wineId"]) || empty($_GET["qty"]))
{
   $_SESSION["message"] = "Nieprawidowe parametry skryptu addtocart.php";
   header("Location: {$_SERVER["HTTP_REFERER"]}");
   exit;
}   

session_start();    

$connection = DB::connect($dsn, true);
if (DB::isError($connection))
  trigger_error($connection->getMessage(), E_USER_ERROR); 

$wineId = pearclean($_GET, "wineId", 5, $connection);
$qty = pearclean($_GET, "qty", 3, $connection);

$update = false;

// Jeeli uytkownik doda towary do koszyka, to bdzie zarejestrowana 
// zmienna $_SESSION["order_no"].

// Na pocztek decyzja, ktre tabele zostan zablokowane.
// Jeeli koszyk istnieje, nie blokujemy orders.
if (isset($_SESSION["order_no"])) 
   $query = "LOCK TABLES inventory READ, items WRITE";
else
   $query = "LOCK TABLES inventory READ, items WRITE, orders WRITE";

// Blokowanie tabel
$result = $connection->query($query);
if (DB::isError($result))
   trigger_error($result->getMessage(), E_USER_ERROR);

// Jeeli nie ma koszyka, tworzenie nowego
// lub sprawdzneie koszyka, jelei istnieje.
if (!isset($_SESSION["order_no"])) 
{
   // Znalezienie maksymalnego order_id, a nastpnie
   // rejestracja zmiennej sesji dla nowej wartoci order_id
   // Koszyk jest zamwieniem dla klienta z cust_id = -1
   $query = "SELECT max(order_id) FROM orders WHERE cust_id = -1";
   $result = $connection->query($query);
   if (DB::isError($result))
      trigger_error($result->getMessage(), E_USER_ERROR);

   // Zapisanie numeru koszyka jako zmiennej order_no.
   // Jest ona wykorzystywana przez wszystkie skrypty koszyka.
   $row = $result->fetchRow(DB_FETCHMODE_ASSOC);
   $_SESSION["order_no"] = $row["max(order_id)"] + 1;

   // Tworzenie nowego koszyka.
   $query = "INSERT INTO orders SET cust_id = -1, 
             order_id = {$_SESSION["order_no"]}";

   $result = $connection->query($query);
   if (DB::isError($result))
      trigger_error($result->getMessage(), E_USER_ERROR);
         
   // Domylna warto item_id to 1
   $item_id = 1;
}
else
{
   // Mamy ju koszyk. Sprawdmy, czy klient ma w nim jakiekolwiek towary.
   $query = "SELECT item_id, qty FROM items WHERE cust_id = -1
             AND order_id = {$_SESSION["order_no"]} 
             AND wine_id = {$wineId}";
   $result = $connection->query($query);
   if (DB::isError($result))
      trigger_error($result->getMessage(), E_USER_ERROR);

   // Czy towar ju jest w koszyku?
   if ($result->numRows() > 0)
   {
      $update = true;
      $row = $result->fetchRow(DB_FETCHMODE_ASSOC);

      // Zapamitanie numeru towaru.
      $item_id = $row["item_id"];
   }
      
   // Jeeli nie jest to modyfikacja, znajdujemy nastpn warto item_id.
   if ($update == false)
   {
      // Mamy ju koszyk, szukamy maksymalnej wartoci item_id
      $query = "SELECT max(item_id) FROM items WHERE cust_id = -1
                AND order_id = {$_SESSION["order_no"]}";
      $result = $connection->query($query);
      if (DB::isError($result))
         trigger_error($result->getMessage(), E_USER_ERROR);

      $row = $result->fetchRow(DB_FETCHMODE_ASSOC);

      // Zapisanie numeru towaru dla nowej pozycji.
      $item_id = $row["max(item_id)"] + 1;
   }   
}
   
// Dodawanie towaru do koszyka lub modyfikacja koszyka.
if ($update == false)
{
   // Pobranie ceny wina.
   // Jest to cena z najtaszej dostawy.
   $query = "SELECT count(*), min(cost) FROM inventory 
             WHERE wine_id = {$wineId}";
   $result = $connection->query($query);
   if (DB::isError($result))
      trigger_error($result->getMessage(), E_USER_ERROR);

   $row = $result->fetchRow(DB_FETCHMODE_ASSOC);

   // To wino mogo zosta wanie sprzedane - sprawdmy to
   // (moe si to zdarzy, jeeli inny uzytkownik kupi ostatni butelk
   //  zanim ten uytkownik kliknie "dodaj do koszyka")
   if ($row["count(*)"] == 0)
      // Rejestracja bdu w zmiennej sesji.
      // Komunikat ten jest wywietlany na stronie z ktrej uytkownik
      // doda wino do koszyka.
      $_SESSION["message"] = 
        "Przepraszamy! Wanie sprzedalimy wszystkie butelki tego wietnego wina!";
   else
   { 
      // Nadal mamy to wino w magazynie, wic zapisujemy
      // najnisz dostpn cen.
      $cost = $row["min(cost)"];
      $query = "INSERT INTO items SET cust_id = -1, 
                order_id = {$_SESSION["order_no"]},
                item_id = {$item_id}, wine_id = {$wineId}, qty = {$qty},
                price = {$cost}";
   }
}
else
   $query = "UPDATE items SET qty = qty + {$qty} 
                          WHERE cust_id = -1
                          AND order_id = {$_SESSION["order_no"]} 
                          AND item_id = {$item_id}";

// Wykonujemy operacj UPDATE lub INSERT
// (jeeli nie wystpi bd)
if (empty($_SESSION["message"]))
{
   $result = $connection->query($query);
   if (DB::isError($result))
      trigger_error($result->getMessage(), E_USER_ERROR);
}

$result = $connection->query("UNLOCK TABLES");
if (DB::isError($result))
   trigger_error($result->getMessage(), E_USER_ERROR);

// Warto HTTP_REFERER nie jest ustawiana przez niektre przegldarki.
// W takim przypadku wracamy do strony gwnej.
if (isset($_SERVER["HTTP_REFERER"]))
  header("Location: {$_SERVER["HTTP_REFERER"]}");
else 
  header("Location: " . S_MAIN);

?>
