<?php
// Source code example for Web Database Applications with PHP and MySQL, 2nd Edition
// Author: Hugh E. Williams, 2001-3
// 
// Unless otherwise stated, the source code distributed with this book can be
// redistributed in source or binary form so long as an acknowledgment appears
// in derived source files.
// The citation should list that the code comes from Hugh E. Williams and David 
// Lane, "Web Database Application with PHP and MySQL" published by O'Reilly & 
// Associates.
//
// This code is under copyright and cannot be included in any other book,
// publication, or educational product without permission from O'Reilly &
// Associates. No warranty is attached; we cannot take responsibility for errors 
// or fitness for use.

// Pokazuje stron logowania.

require_once "../includes/template.inc";
require_once "../includes/winestore.inc";
require_once "../includes/validate.inc";

set_error_handler("customHandler");

session_start();

// Jako parametrw potrzebuje nagwka formularza, instrukcji, akcji, nazwy tabeli formVars
// oraz formErrors
$template = new winestoreFormTemplate("Logowanie", 
                "Prosz poda nazw uytkownika i haso.",
                S_LOGINCHECK, "loginFormVars", "loginErrors");


$template->mandatoryWidget("loginUsername", "Nazwa uytkowika/email:", 50);
$template->passwordWidget("loginPassword", "Haso:", 8);

// Dodanie przyciskw, komunikatw i pokazanie strony.
$template->showWinestore(NO_CART, B_HOME);
?>
