<?php
  require "class.ezpdf.php";
  require "alicja.inc";

  // Utworzenie nowego dokumentu PDF
  $doc =& new Cezpdf();

  // Uycie w nagwkach czcionki Helvetica
  $doc->selectFont("./fonts/Helvetica.afm");

  // Wstawienie nagwka ksiki oraz autora
  $doc->ezText("<u>Alice's Adventures in Wonderland</u>", 24,
                array("justification"=>"center"));
  $doc->ezText("by Lewis Carroll", 20, array("justification"=>"center"));

  // Wstawienie wolnego miejsca
  $doc->ezSetDy(-10);

  // Wstawienie tytuu rozdziau
  $doc->ezText("Chapter 1: Down the Rabbit-Hole", 18,
                array("justification"=>"center"));

  // Ponumerowanie stron
  $doc->ezStartPageNumbers(320, 15, 8,"",
     "{PAGENUM} of {TOTALPAGENUM} pages");

  // Wstawienie wolnego miejsca
  $doc->ezSetDy(-30);

  // Wczenie trybu z dwiema kolumnami
  $doc->ezColumnsStart(array("num"=>2, "gap"=>15));

  // Ustawienie czcionki Times-Roman dla tekstu
  $doc->selectFont("./fonts/Times-Roman.afm");

  // Doczenie obrazka i podpisu
  $doc->ezImage("krolik.jpg", "", "", "none");
  $doc->ezText("<b>White Rabbit checking watch</b>",
               12,array("justification"=>"center"));

  // Wstawienie wolnego miejsca
  $doc->ezSetDy(-10);

  // Dodanie do dokumentu treci rozdziau
  $doc->ezText($text,10,array("justification"=>"full"));

  // Wygenerowanie dokumentu
  $doc->ezStream();
?>
